/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl;

import com.novell.xml.sax.SAXtoDOM;
import com.novell.xml.util.XMLUtil;
import com.novell.xsl.process.StripList;
import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class SAXtoDOMStrip
extends SAXtoDOM {
    protected Node currentText = null;
    protected final StripList stripList;
    protected boolean xmlSpacePreserve = false;
    protected Stack stack = new Stack();

    public SAXtoDOMStrip(Document document, StripList stripList) {
        super(document);
        this.stripList = stripList;
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        this.strip();
    }

    public void startElement(String name, AttributeList atts) throws SAXException {
        this.strip();
        super.startElement(name, atts);
        this.pushState();
        String value = ((Element)this.currentNode).getAttribute("xml:space");
        if (value.length() > 0) {
            if (value.equals("preserve")) {
                this.xmlSpacePreserve = true;
            } else if (value.equals("default")) {
                this.xmlSpacePreserve = false;
            }
        }
    }

    public void endElement(String name) throws SAXException {
        this.strip();
        super.endElement(name);
        this.popState();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
        this.currentText = this.currentNode.getLastChild();
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.strip();
        super.processingInstruction(target, data);
    }

    public void comment(String data) throws SAXException {
        this.strip();
        super.comment(data);
    }

    protected void strip() {
        if (this.currentText != null && this.stripNode(this.currentText)) {
            this.currentText.getParentNode().removeChild(this.currentText);
        }
        this.currentText = null;
    }

    public boolean stripNode(Node node) {
        if (this.stripList == null || this.stripList.size() == 0) {
            return false;
        }
        String nodeValue = node.getNodeValue();
        if (nodeValue == null) {
            return false;
        }
        if (XMLUtil.isXMLWhitespace(nodeValue)) {
            if (!this.stripList.checkStrip(node.getParentNode())) {
                return false;
            }
            return !this.xmlSpacePreserve;
        }
        return false;
    }

    protected void pushState() {
        this.stack.push(this.xmlSpacePreserve ? Boolean.TRUE : Boolean.FALSE);
    }

    protected void popState() {
        this.xmlSpacePreserve = (Boolean)this.stack.pop();
    }
}

