/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl;

import com.novell.util.URIResolver;
import com.novell.xml.dom.DOMUtil;
import com.novell.xml.dom.DocumentFactory;
import com.novell.xml.dom.DocumentImpl;
import com.novell.xml.dom.NodeImpl;
import com.novell.xml.parser.XMLParser;
import com.novell.xml.parser.XMLParserFactory;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.util.StylesheetAssociation;
import com.novell.xml.util.XMLUtil;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.Parser;
import com.novell.xml.xpath.VariableBindings;
import com.novell.xml.xpath.XPathConversionException;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathParserException;
import com.novell.xml.xpath.XPathResetCache;
import com.novell.xml.xpath.XPathResetRegistrar;
import com.novell.xsl.DefaultErrorHandler;
import com.novell.xsl.DefaultMessageHandler;
import com.novell.xsl.ErrorHandler;
import com.novell.xsl.MessageHandler;
import com.novell.xsl.XSLException;
import com.novell.xsl.XmlHook;
import com.novell.xsl.extensions.JavaInstance;
import com.novell.xsl.parser.StylesheetParser;
import com.novell.xsl.parser.XSLTParserException;
import com.novell.xsl.parser.XsltFunctionLibrary;
import com.novell.xsl.process.AttributeSet;
import com.novell.xsl.process.Context;
import com.novell.xsl.process.Key;
import com.novell.xsl.process.Mode;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.RuleCollection;
import com.novell.xsl.process.StripList;
import com.novell.xsl.process.TopLevelVariableTemplate;
import com.novell.xsl.result.DOMResult;
import com.novell.xsl.result.DOMResultHandler;
import com.novell.xsl.result.DefaultSerializer;
import com.novell.xsl.result.HTMLSerializer;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.result.Serializer;
import com.novell.xsl.result.SerializerOptions;
import com.novell.xsl.result.TextSerializer;
import com.novell.xsl.result.XMLSerializer;
import com.novell.xsl.util.Util;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Stylesheet
implements XPathResetRegistrar,
VariableBindings {
    public static final NamespaceName NAMESPACE = new NamespaceName("http://www.w3.org/1999/XSL/Transform");
    public static final String VERSION = "1.0";
    public static final NamespaceName NXSL_NAMESPACE = new NamespaceName("http://www.novell.com/nxsl");
    public static final String EXTENSION_FUNCTION_MAGIC = "http://www.novell.com/nxsl/java/";
    public static final String XSLT_VERSION = "1.0";
    private URL baseURI = null;
    private Node stylesheetDocument;
    private String id;
    private boolean isLoaded;
    private RuleCollection templateRules = new RuleCollection();
    private StripList stripList = new StripList();
    private Map decimalFormatMap = null;
    private static final ExpandedQName defaultDecimalFormatName = new ExpandedQName(NAMESPACE, "#default#");
    private Map keyMap = null;
    private Map attributeSetMap = null;
    private Map namespaceAliasMap = null;
    private List resetList = new ArrayList();
    private int invocationCount;
    private ErrorHandler errorHandler = new DefaultErrorHandler();
    private MessageHandler messageHandler = new DefaultMessageHandler();
    private Context context;
    private Map topLevelVariables = null;
    private List actualParameters = new ArrayList();
    private SerializerOptions serializerOptions = null;
    private int serializerOptionsImportance;
    private ResultHandler resultHandler = null;
    private OutputStream serializerStream = null;
    private String[] mimeTypes = SUPPORTED_MIME_TYPES;
    private XmlHook documentHook = null;
    private boolean brokenMode = false;
    private static final String[] SUPPORTED_MIME_TYPES = new String[]{new String("text/xml"), new String("application/xml")};

    public Stylesheet() {
        this.context = new Context(this, new XsltFunctionLibrary(), null);
    }

    public Stylesheet(Map properties) {
        this.context = new Context(this, new XsltFunctionLibrary(), properties);
    }

    public Stylesheet(ClassLoader extensionFunctionLoader) {
        this.context = new Context(this, new XsltFunctionLibrary(extensionFunctionLoader), null);
    }

    public Stylesheet(ClassLoader extensionFunctionLoader, Map properties) {
        this.context = new Context(this, new XsltFunctionLibrary(extensionFunctionLoader), properties);
    }

    public Stylesheet(Document xslDocument) throws XSLException {
        this.context = new Context(this, new XsltFunctionLibrary(), null);
        this.load(xslDocument);
    }

    public Stylesheet(Document xslDocument, Map properties) throws XSLException {
        this.context = new Context(this, new XsltFunctionLibrary(), properties);
        this.load(xslDocument);
    }

    public Stylesheet(Document xslDocument, boolean brokenMode) throws XSLException {
        this.context = new Context(this, new XsltFunctionLibrary(), null);
        this.setBrokenMode(brokenMode);
        this.load(xslDocument);
    }

    public Stylesheet(Document xslDocument, boolean brokenMode, Map properties) throws XSLException {
        this.context = new Context(this, new XsltFunctionLibrary(), properties);
        this.setBrokenMode(brokenMode);
        this.load(xslDocument);
    }

    public Stylesheet(Document xslDocument, ClassLoader extensionFunctionLoader) throws XSLException {
        this.context = new Context(this, new XsltFunctionLibrary(extensionFunctionLoader), null);
        this.load(xslDocument);
    }

    public Stylesheet(Document xslDocument, ClassLoader extensionFunctionLoader, Map properties) throws XSLException {
        this.context = new Context(this, new XsltFunctionLibrary(extensionFunctionLoader), properties);
        this.load(xslDocument);
    }

    public Stylesheet(Document xslDocument, ClassLoader extensionFunctionLoader, boolean brokenMode) throws XSLException {
        this.context = new Context(this, new XsltFunctionLibrary(extensionFunctionLoader), null);
        this.setBrokenMode(brokenMode);
        this.load(xslDocument);
    }

    public Stylesheet(Document xslDocument, ClassLoader extensionFunctionLoader, boolean brokenMode, Map properties) throws XSLException {
        this.context = new Context(this, new XsltFunctionLibrary(extensionFunctionLoader), properties);
        this.setBrokenMode(brokenMode);
        this.load(xslDocument);
    }

    public Stylesheet(Document xslDocument, String xslURI) throws XSLException {
        this.context = new Context(this, new XsltFunctionLibrary(), null);
        try {
            this.setBaseURI(xslURI);
        }
        catch (MalformedURLException e) {
            this.errorHandler.error(e.toString());
        }
        this.load(xslDocument);
    }

    public Stylesheet(Document xslDocument, String xslURI, Map properties) throws XSLException {
        this.context = new Context(this, new XsltFunctionLibrary(), properties);
        try {
            this.setBaseURI(xslURI);
        }
        catch (MalformedURLException e) {
            this.errorHandler.error(e.toString());
        }
        this.load(xslDocument);
    }

    public Stylesheet(Document xslDocument, String xslURI, boolean brokenMode) throws XSLException {
        this.context = new Context(this, new XsltFunctionLibrary(), null);
        this.setBrokenMode(brokenMode);
        try {
            this.setBaseURI(xslURI);
        }
        catch (MalformedURLException e) {
            this.errorHandler.error(e.toString());
        }
        this.load(xslDocument);
    }

    public Stylesheet(Document xslDocument, String xslURI, boolean brokenMode, Map properties) throws XSLException {
        this.context = new Context(this, new XsltFunctionLibrary(), properties);
        this.setBrokenMode(brokenMode);
        try {
            this.setBaseURI(xslURI);
        }
        catch (MalformedURLException e) {
            this.errorHandler.error(e.toString());
        }
        this.load(xslDocument);
    }

    public Stylesheet(Document xslDocument, String xslURI, ClassLoader extensionFunctionLoader) throws XSLException {
        this.context = new Context(this, new XsltFunctionLibrary(extensionFunctionLoader), null);
        try {
            this.setBaseURI(xslURI);
        }
        catch (MalformedURLException e) {
            this.errorHandler.error(e.toString());
        }
        this.load(xslDocument);
    }

    public Stylesheet(Document xslDocument, String xslURI, ClassLoader extensionFunctionLoader, Map properties) throws XSLException {
        this.context = new Context(this, new XsltFunctionLibrary(extensionFunctionLoader), properties);
        try {
            this.setBaseURI(xslURI);
        }
        catch (MalformedURLException e) {
            this.errorHandler.error(e.toString());
        }
        this.load(xslDocument);
    }

    public Stylesheet(Document xslDocument, String xslURI, ClassLoader extensionFunctionLoader, boolean brokenMode) throws XSLException {
        this.context = new Context(this, new XsltFunctionLibrary(extensionFunctionLoader), null);
        this.setBrokenMode(brokenMode);
        try {
            this.setBaseURI(xslURI);
        }
        catch (MalformedURLException e) {
            this.errorHandler.error(e.toString());
        }
        this.load(xslDocument);
    }

    public Stylesheet(Document xslDocument, String xslURI, ClassLoader extensionFunctionLoader, boolean brokenMode, Map properties) throws XSLException {
        this.context = new Context(this, new XsltFunctionLibrary(extensionFunctionLoader), properties);
        this.setBrokenMode(brokenMode);
        try {
            this.setBaseURI(xslURI);
        }
        catch (MalformedURLException e) {
            this.errorHandler.error(e.toString());
        }
        this.load(xslDocument);
    }

    public Context getContext() {
        return this.context;
    }

    public boolean setBrokenMode(boolean newMode) {
        boolean oldMode = this.brokenMode;
        this.brokenMode = newMode;
        return oldMode;
    }

    public void setResultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
    }

    public ResultHandler getResultHandler() {
        return this.resultHandler;
    }

    public void setSerializerStream(OutputStream serializerStream) {
        this.serializerStream = serializerStream;
    }

    public OutputStream getSerializerStream() {
        return this.serializerStream;
    }

    public void setParameter(String paramName, String expressionString) {
        this.actualParameters.add(new StringParameter(paramName, expressionString));
    }

    public void setParameter(String paramName, Object value) {
        this.actualParameters.add(new ValueParameter(paramName, value));
    }

    public void clearParameters() {
        this.actualParameters.clear();
    }

    public XmlHook setXmlHook(XmlHook hook) {
        XmlHook oldHook = this.documentHook;
        this.documentHook = hook;
        return oldHook;
    }

    public XmlHook getXmlHook() {
        return this.documentHook;
    }

    public URL getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(URL baseURI) {
        this.baseURI = baseURI;
    }

    public void setBaseURI(String uri) throws MalformedURLException {
        URL fileBase = XMLUtil.filenameToURL(".");
        String resolvedURI = URIResolver.resolveURI(uri, fileBase.toString());
        this.baseURI = new URL(resolvedURI);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public RuleCollection getTemplateRules() {
        return this.templateRules;
    }

    public StripList getStripList() {
        return this.stripList;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            throw new IllegalArgumentException("null error handler");
        }
        this.errorHandler = errorHandler;
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void setMessageHandler(MessageHandler messageHandler) {
        if (messageHandler == null) {
            throw new IllegalArgumentException("null message handler");
        }
        this.messageHandler = messageHandler;
    }

    public SerializerOptions getSerializerOptions() {
        return this.serializerOptions;
    }

    public void setSerializerOptions(SerializerOptions serializerOptions, int importance) {
        if (this.serializerOptions != null) {
            if (importance >= this.serializerOptionsImportance) {
                serializerOptions.merge(this.serializerOptions);
                this.serializerOptions = serializerOptions;
                this.serializerOptionsImportance = importance;
            } else {
                this.serializerOptions.merge(serializerOptions);
            }
        } else {
            this.serializerOptions = serializerOptions;
        }
    }

    public void setTopLevelVariable(TopLevelVariableTemplate variable) throws XSLException {
        TopLevelVariableTemplate found;
        if (this.topLevelVariables == null) {
            this.topLevelVariables = new HashMap();
        }
        if ((found = (TopLevelVariableTemplate)this.topLevelVariables.get(variable.getName())) != null) {
            if (found.getImportance() > variable.getImportance()) {
                variable.replace(found);
                return;
            }
            if (found.getImportance() == variable.getImportance()) {
                throw new XSLException(XSLTParserException.constructMessage("spe7", new String[]{variable.getName().getQName()}));
            }
            found = (TopLevelVariableTemplate)this.topLevelVariables.remove(variable.getName());
            found.replace(variable);
        }
        this.topLevelVariables.put(variable.getName(), variable);
    }

    public TopLevelVariableTemplate getTopLevelVariable(ExpandedQName name) {
        return this.topLevelVariables != null ? (TopLevelVariableTemplate)this.topLevelVariables.get(name) : null;
    }

    public void setDecimalFormat(ExpandedQName name, DecimalFormatSymbols decimalFormat) {
        if (name == null) {
            name = defaultDecimalFormatName;
        }
        if (this.decimalFormatMap == null) {
            this.decimalFormatMap = new HashMap();
        } else {
            this.decimalFormatMap.remove(name);
        }
        this.decimalFormatMap.put(name, decimalFormat);
    }

    public DecimalFormatSymbols getDecimalFormat(ExpandedQName name) {
        DecimalFormatSymbols decimalFormat;
        if (name == null) {
            name = defaultDecimalFormatName;
        }
        DecimalFormatSymbols decimalFormatSymbols = decimalFormat = this.decimalFormatMap != null ? (DecimalFormatSymbols)this.decimalFormatMap.get(name) : null;
        if (decimalFormat == null && name.equals(defaultDecimalFormatName)) {
            decimalFormat = new DecimalFormatSymbols();
            this.setDecimalFormat(null, decimalFormat);
        }
        return decimalFormat;
    }

    public void setKey(Key key) {
        if (this.keyMap == null) {
            this.keyMap = new HashMap();
        } else {
            this.keyMap.remove(key.getName());
            this.resetList.remove(key);
        }
        this.keyMap.put(key.getName(), key);
        this.resetList.add(key);
    }

    public Key getKey(ExpandedQName name) {
        return this.keyMap != null ? (Key)this.keyMap.get(name) : null;
    }

    public void setAttributeSet(AttributeSet attributeSet) throws XSLException {
        AttributeSet existingSet;
        if (this.attributeSetMap == null) {
            this.attributeSetMap = new HashMap();
        }
        if ((existingSet = (AttributeSet)this.attributeSetMap.get(attributeSet.getName())) != null) {
            existingSet.merge(attributeSet);
        } else {
            this.attributeSetMap.put(attributeSet.getName(), attributeSet);
        }
    }

    public AttributeSet getAttributeSet(ExpandedQName setName) {
        return this.attributeSetMap != null ? (AttributeSet)this.attributeSetMap.get(setName) : null;
    }

    public void setNamespaceAlias(NamespaceName alias, NamespaceName resultName, String resultPrefix, int importance) {
        ResultNamespace namespaceRecord;
        if (this.namespaceAliasMap == null) {
            this.namespaceAliasMap = new HashMap();
        }
        if ((namespaceRecord = (ResultNamespace)this.namespaceAliasMap.get(alias)) != null) {
            if (namespaceRecord.getImportance() > importance) {
                return;
            }
            this.namespaceAliasMap.remove(alias);
        }
        this.namespaceAliasMap.put(alias, new ResultNamespace(resultName, resultPrefix, importance));
    }

    public NamespaceName getAliasedNamespace(NamespaceName alias) {
        ResultNamespace namespaceRecord = this.namespaceAliasMap != null ? (ResultNamespace)this.namespaceAliasMap.get(alias) : null;
        return namespaceRecord == null ? null : namespaceRecord.getResultName();
    }

    public String getAliasedPrefix(NamespaceName alias) {
        ResultNamespace namespaceRecord = this.namespaceAliasMap != null ? (ResultNamespace)this.namespaceAliasMap.get(alias) : null;
        return namespaceRecord == null ? null : namespaceRecord.getResultPrefix();
    }

    public void setMimeTypes(String[] mimeTypes) {
        this.mimeTypes = mimeTypes;
    }

    public void load(Document xslDocument) throws XSLTParserException {
        if (this.isLoaded) {
            throw new RuntimeException("stylesheet already loaded");
        }
        if (this.baseURI == null && xslDocument instanceof NodeImpl && ((NodeImpl)((Object)xslDocument)).getBaseURI() != null) {
            try {
                this.setBaseURI(((NodeImpl)((Object)xslDocument)).getBaseURI());
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        this.stylesheetDocument = xslDocument;
        StylesheetParser parser = new StylesheetParser(this, this.context.getFunctionLibrary(), this.brokenMode);
        parser.setBuiltInDefinitions(xslDocument);
        parser.parse(xslDocument, this.baseURI);
        this.templateRules.optimize();
        this.stripList.optimize();
        this.isLoaded = true;
        this.invocationCount = 0;
    }

    public void loadFromSource(Document xmlDocument, String documentURI) throws XSLTParserException {
        int i;
        if (this.isLoaded) {
            throw new RuntimeException("stylesheet already loaded");
        }
        StylesheetParser parser = new StylesheetParser(this, this.context.getFunctionLibrary(), this.brokenMode);
        StylesheetAssociation[] stylesheets = DOMUtil.getStylesheetAssociations(xmlDocument, documentURI);
        if (stylesheets.length < 1) {
            parser.reportError(xmlDocument, "spe22");
            return;
        }
        int count = 0;
        for (int i2 = 0; i2 < stylesheets.length; ++i2) {
            String type = stylesheets[i2].getType();
            for (int j = 0; j < this.mimeTypes.length; ++j) {
                if (!type.equals(this.mimeTypes[j])) continue;
                ++count;
            }
        }
        if (count == 0) {
            parser.reportError(xmlDocument, "spe23");
        }
        Document xslDocument = null;
        if (count == 1) {
            XMLParser xmlParser = XMLParserFactory.newParser();
            for (i = 0; i < stylesheets.length; ++i) {
                String type = stylesheets[i].getType();
                boolean matchType = false;
                for (int j = 0; j < this.mimeTypes.length; ++j) {
                    if (!type.equals(this.mimeTypes[j])) continue;
                    matchType = true;
                    break;
                }
                if (!matchType || stylesheets[i].isAlternate()) continue;
                try {
                    xslDocument = xmlParser.parse(stylesheets[i].getHref());
                    if (xmlParser.anyErrors()) {
                        parser.reportError(xmlParser.getErrorMsgString());
                        return;
                    }
                    this.setBaseURI(stylesheets[i].getHref());
                    continue;
                }
                catch (IOException e) {
                    parser.reportError(e.toString());
                    return;
                }
            }
        } else {
            xslDocument = DocumentFactory.newDocument();
            ((DocumentImpl)xslDocument).setBaseURI(documentURI);
            Element stylesheet = xslDocument.createElement("xsl:stylesheet");
            xslDocument.appendChild(stylesheet);
            stylesheet.setAttribute("xmlns:xsl", NAMESPACE.getString());
            stylesheet.setAttribute("version", "1.0");
            for (i = 0; i < stylesheets.length; ++i) {
                String type = stylesheets[i].getType();
                boolean matchType = false;
                for (int j = 0; j < this.mimeTypes.length; ++j) {
                    if (!type.equals(this.mimeTypes[j])) continue;
                    matchType = true;
                    break;
                }
                if (!matchType || stylesheets[i].isAlternate()) continue;
                Element include = xslDocument.createElement("xsl:include");
                stylesheet.appendChild(include);
                include.setAttribute("href", stylesheets[i].getHref());
            }
        }
        this.load(xslDocument);
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void processStripped(Node sourceDocument, URL sourceURI) throws XSLException {
        this.process(sourceDocument, sourceURI, true);
    }

    public void process(Node sourceDocument, URL sourceURI) throws XSLException {
        this.process(sourceDocument, sourceURI, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Node sourceDocument, URL sourceURI, boolean alreadyStripped) throws XSLException {
        short nodeType;
        if (sourceDocument == null || (nodeType = sourceDocument.getNodeType()) != 9 && nodeType != 11) {
            throw new IllegalArgumentException("Illegal sourceDocument argument");
        }
        if (!this.isLoaded) {
            new StylesheetParser(this, this.context.getFunctionLibrary(), this.brokenMode).setBuiltInDefinitions(sourceDocument);
            this.templateRules.optimize();
            this.stripList.optimize();
            this.isLoaded = true;
            this.invocationCount = 0;
        } else if (++this.invocationCount > 1) {
            // empty if block
        }
        this.context.setStripList(alreadyStripped ? null : this.stripList);
        try {
            this.setupResultHandler();
            Document nodeFactory = this.resultHandler instanceof DOMResult ? ((DOMResult)((Object)this.resultHandler)).getDocument() : DocumentFactory.newDocument();
            ProcessingEnv env = new ProcessingEnv(this, this.context, nodeFactory, this.errorHandler, this.messageHandler, this.resultHandler);
            NodeSet initialNodeList = new NodeSet();
            initialNodeList.add(sourceDocument);
            this.context.setContextNodeList(initialNodeList);
            this.context.clearBaseURIs();
            if (sourceURI != null) {
                this.context.addBaseURI(sourceDocument, sourceURI);
            }
            this.context.addBaseURI(this.stylesheetDocument, this.baseURI);
            Context lazyContext = new Context(this.context);
            lazyContext.setNamespaceContext(this.stylesheetDocument);
            ProcessingEnv lazyEnv = new ProcessingEnv(this, lazyContext, nodeFactory, this.errorHandler, this.messageHandler, this.resultHandler);
            Iterator<Object> it = this.actualParameters.iterator();
            while (it.hasNext()) {
                ActualParameter param = (ActualParameter)it.next();
                ExpandedQName name = this.context.getExpandedName(param.getQName());
                if (this.topLevelVariables == null || !this.topLevelVariables.containsKey(name)) continue;
                try {
                    lazyEnv.bindParameter(name, param.evaluate(sourceDocument, this.context));
                }
                catch (XPathEvaluationException e) {
                    this.errorHandler.error(XSLException.constructMessage("e3", new String[]{e.getMessage()}));
                }
            }
            if (this.topLevelVariables != null) {
                it = this.topLevelVariables.values().iterator();
                while (it.hasNext()) {
                    TopLevelVariableTemplate template = (TopLevelVariableTemplate)it.next();
                    template.setLazyEnv(lazyEnv);
                }
            }
            this.resultHandler.startDocument();
            env.process(sourceDocument, Mode.DEFAULT_MODE, this.resultHandler);
            this.resultHandler.endDocument();
        }
        catch (ResultException e) {
            this.errorHandler.error(e.toString());
        }
        finally {
            this.reset();
        }
    }

    public void dump(PrintWriter out) {
        this.dump(out, 0);
    }

    public void dump(PrintWriter out, int indent) {
        Util.indent(out, indent);
        out.println("stylesheet id=" + this.id);
        for (int i = 0; i < indent; ++i) {
            out.print("\t");
        }
        out.println("\ttemplate rules");
        this.templateRules.dump(out, indent + 1);
        out.println("\nstrip/preserve-space elements");
        this.stripList.dump(out, indent + 1);
        out.println("\nkeys");
        if (this.keyMap != null) {
            Iterator keyIt = this.keyMap.keySet().iterator();
            while (keyIt.hasNext()) {
                ((Key)this.keyMap.get(keyIt.next())).dump(out, indent + 1);
            }
        }
        out.println("\ndecimal-format objects");
        if (this.decimalFormatMap != null) {
            Iterator dfIt = this.decimalFormatMap.keySet().iterator();
            while (dfIt.hasNext()) {
                Util.indent(out, indent);
                this.decimalFormatMap.get(dfIt.next()).toString();
                out.println();
            }
        }
    }

    private void setupResultHandler() {
        if (this.resultHandler == null) {
            if (this.serializerStream != null) {
                ExpandedQName method;
                ExpandedQName expandedQName = method = this.serializerOptions == null ? null : this.serializerOptions.getMethod();
                if (method == null) {
                    this.resultHandler = new DefaultSerializer();
                } else if (method.getNamespaceName().isEmpty()) {
                    String methodName = method.getLocalPart();
                    if (methodName.equals("xml")) {
                        this.resultHandler = new XMLSerializer();
                    } else if (methodName.equals("html")) {
                        this.resultHandler = new HTMLSerializer();
                    } else if (methodName.equals("text")) {
                        this.resultHandler = new TextSerializer();
                    }
                } else if (method.getNamespaceName().getString().startsWith(EXTENSION_FUNCTION_MAGIC)) {
                    String nsName = method.getNamespaceName().getString();
                    String className = nsName.substring(EXTENSION_FUNCTION_MAGIC.length(), nsName.length());
                    try {
                        Class<?> rhClass = Class.forName(className);
                        if (Class.forName("com.novell.xsl.result.Serializer").isAssignableFrom(rhClass) && Class.forName("com.novell.xsl.result.ResultHandler").isAssignableFrom(rhClass)) {
                            this.resultHandler = (ResultHandler)rhClass.newInstance();
                        } else {
                            this.errorHandler.warning(XSLException.constructMessage("e4", new String[]{className}));
                        }
                    }
                    catch (ClassNotFoundException e) {
                        this.errorHandler.warning(XSLException.constructMessage("e4", new String[]{className}));
                    }
                    catch (InstantiationException e) {
                        this.errorHandler.warning(XSLException.constructMessage("e4", new String[]{className}));
                    }
                    catch (IllegalAccessException e) {
                        // empty catch block
                    }
                }
                if (this.resultHandler == null) {
                    this.resultHandler = new DefaultSerializer();
                }
            } else {
                this.resultHandler = new DOMResultHandler(DocumentFactory.newDocument());
            }
        }
        if (this.resultHandler instanceof Serializer) {
            if (this.serializerOptions != null) {
                ((Serializer)((Object)this.resultHandler)).setOptions(this.serializerOptions);
            }
            if (this.serializerStream != null) {
                ((Serializer)((Object)this.resultHandler)).setStream(this.serializerStream);
            }
        }
    }

    public void registerResetCache(XPathResetCache reset) {
        this.resetList.add(reset);
    }

    private void reset() {
        Iterator it = this.resetList.iterator();
        while (it.hasNext()) {
            ((XPathResetCache)it.next()).resetCache();
        }
    }

    public Expression getVariable(ExpandedQName varName) {
        return (Expression)this.topLevelVariables.get(varName);
    }

    private class ValueParameter
    extends ActualParameter {
        private final ExpressionValue value;

        public ValueParameter(String qName, Object value) {
            super(qName);
            if (value instanceof ExpressionValue) {
                this.value = (ExpressionValue)value;
            } else if (value instanceof Node) {
                NodeSet set = new NodeSet();
                set.add((Node)value);
                this.value = set;
            } else {
                Class wrapType = JavaInstance.getReturnType(value.getClass());
                try {
                    this.value = (ExpressionValue)wrapType.newInstance();
                    this.value.castFrom(value);
                }
                catch (XPathConversionException e) {
                    throw new Error(e.getMessage());
                }
                catch (IllegalAccessException e) {
                    throw new Error(e.getMessage());
                }
                catch (InstantiationException e) {
                    throw new Error(e.getMessage());
                }
            }
        }

        public ExpressionValue evaluate(Node contextNode, ExpressionContext context) {
            return this.value;
        }
    }

    private class StringParameter
    extends ActualParameter {
        private final String expString;

        public StringParameter(String qName, String expString) {
            super(qName);
            this.expString = expString;
        }

        public ExpressionValue evaluate(Node contextNode, ExpressionContext context) throws XPathEvaluationException {
            Parser parser = new Parser(Stylesheet.this, ((Context)context).getFunctionLibrary(), context);
            try {
                return parser.parse(this.expString).evaluate(contextNode, context);
            }
            catch (XPathParserException e) {
                throw new XPathEvaluationException(e.getMessage());
            }
        }
    }

    private abstract class ActualParameter {
        private final String qName;

        public ActualParameter(String qName) {
            this.qName = qName;
        }

        public abstract ExpressionValue evaluate(Node var1, ExpressionContext var2) throws XPathEvaluationException;

        public String getQName() {
            return this.qName;
        }
    }

    private static class ResultNamespace {
        private NamespaceName resultName;
        private String resultPrefix;
        private int importance;

        public ResultNamespace(NamespaceName resultName, String resultPrefix, int importance) {
            this.resultName = resultName;
            this.resultPrefix = resultPrefix;
            this.importance = importance;
        }

        public int getImportance() {
            return this.importance;
        }

        public NamespaceName getResultName() {
            return this.resultName;
        }

        public String getResultPrefix() {
            return this.resultPrefix;
        }
    }
}

