/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class XSLException
extends Exception {
    public static final String ERROR_PROLOGUE = "e1";
    public static final String WARNING_PROLOGUE = "e2";
    public static final String STYLESHEET_PARM_ERROR = "e3";
    public static final String INVALID_RESULT_HANDLER = "e4";
    private boolean noError;

    public XSLException() {
        this.noError = false;
    }

    public XSLException(String key) {
        super(XSLException.constructMessage(key, null));
        this.noError = false;
    }

    public XSLException(String key, String parm0) {
        super(XSLException.constructMessage(key, new String[]{parm0}));
        this.noError = false;
    }

    public XSLException(String key, boolean noError) {
        super(XSLException.constructMessage(key, null));
        this.noError = noError;
    }

    public boolean isError() {
        return !this.noError;
    }

    public static String constructMessage(String key, Object[] parms) {
        ResourceBundle bundle = ResourceBundle.getBundle("com.novell.xsl.Stylesheet_errors");
        try {
            key = bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
        return parms == null ? key : MessageFormat.format(key, parms);
    }
}

