/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.extensions;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.StringValue;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.parser.AttrDef;
import com.novell.xsl.parser.StylesheetParser;
import com.novell.xsl.parser.XSLTParserException;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.ResultTreeFragment;
import com.novell.xsl.process.Template;
import com.novell.xsl.process.VariablePlaceholder;
import com.novell.xsl.process.VariableTemplate;
import com.novell.xsl.result.FragmentHandler;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AssignVariableTemplate
extends VariableTemplate {
    protected Expression variable;
    private static AttrDef[] nxslAssignVariableAttr = new AttrDef[]{new AttrDef("name", 1, null, 6), new AttrDef("select", 0, null, 11)};

    public static Template parse(StylesheetParser stylesheetParser, Element element) throws XSLTParserException {
        Object[] attr = AttrDef.parseAttributes(stylesheetParser, element, nxslAssignVariableAttr);
        if (attr[0] == null) {
            return null;
        }
        ExpandedQName name = (ExpandedQName)attr[0];
        Expression variable = stylesheetParser.getVariables().getVariable(name);
        Expression select = (Expression)attr[1];
        Template[] templates = stylesheetParser.parseTemplates(element.getFirstChild(), false);
        return new AssignVariableTemplate(name, select, templates, variable, (Node)element);
    }

    protected AssignVariableTemplate(ExpandedQName name, Expression select, Template[] templates, Expression variable, Node nsContext) {
        super(name, select, templates, nsContext);
        this.variable = variable;
    }

    public void instantiate(ProcessingEnv env, Node currentNode, ResultHandler result) throws XSLException {
        Trace.traceTemplate("assign-variable");
        try {
            ExpressionValue value;
            if (this.getSelect() != null) {
                value = env.getContext().evaluate(currentNode, this.getSelect());
                Trace.traceSelect(this.getSelect(), value);
            } else if (this.getTemplates().length == 0) {
                value = new StringValue();
            } else {
                FragmentHandler fragmentHandler = new FragmentHandler(env.getNodeFactory());
                this.instantiateTemplates(env, currentNode, fragmentHandler);
                value = new ResultTreeFragment(fragmentHandler.getFragment());
            }
            if (this.variable instanceof VariableTemplate) {
                ((VariableTemplate)this.variable).setCurrentValue(value);
            } else if (this.variable instanceof VariablePlaceholder) {
                ((VariablePlaceholder)this.variable).setCurrentValue(value);
            }
        }
        catch (XPathEvaluationException e) {
            env.reportError(this.getNamespaceContext(), "pe2", e.getMessage());
        }
    }

    public void dump(PrintWriter out, int indent) {
        Util.indent(out, indent);
        out.println("assign-variable");
        super.dump(out, indent + 1);
    }
}

