/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.extensions;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.Function;
import com.novell.xml.xpath.FunctionSignature;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathUtil;
import com.novell.xsl.XSLException;
import com.novell.xsl.extensions.ECMAScriptFunctionImpl;
import com.novell.xsl.extensions.ExtensionException;
import com.novell.xsl.parser.AttrDef;
import com.novell.xsl.parser.StylesheetParser;
import com.novell.xsl.parser.XSLTParserException;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.w3c.dom.Element;

public class ECMAScriptFunction
extends Function {
    public static final String ECMASCRIPT_EXTENSION_FUNCTION_NAMESPACE = "http://www.novell.com/nxsl/ecmascript";
    public static final String ECMASCRIPT_SCOPE_PROPERTY = "com.novell.xsl.extensions.ECMAScriptFunction.scope";
    private static boolean checkedRhinoAvailable = false;
    private static boolean rhinoAvailable = false;
    protected static final Class defaultParameterType = XPathUtil.doGetClass("java.lang.Object");
    protected static final Class defaultReturnType = XPathUtil.doGetClass("com.novell.xml.xpath.NodeSet");
    protected static final Class[] optArgs;
    protected static final AttrDef[] scriptAttr;

    protected ECMAScriptFunction(FunctionSignature signature) {
        super(signature);
    }

    private ECMAScriptFunction(ExpandedQName name) {
        super(new FunctionSignature(name, defaultReturnType, FunctionSignature.getContextArgTypes(), optArgs));
    }

    public static ECMAScriptFunction create(ExpandedQName name, ClassLoader classLoader) {
        if (ECMAScriptFunction.isECMAScriptAvailable()) {
            return new ECMAScriptFunctionImpl(name, classLoader);
        }
        return new ECMAScriptFunction(name);
    }

    public ExpressionValue invoke(Object[] args) throws XPathEvaluationException {
        String message = new ExtensionException("ee4").getMessage();
        throw new XPathEvaluationException(message);
    }

    public boolean available(ExpressionContext eContext) {
        return false;
    }

    public static void parse(StylesheetParser stylesheetParser, Element element, URL baseURI, ClassLoader classLoader) throws XSLTParserException {
        if (ECMAScriptFunction.isECMAScriptAvailable()) {
            ECMAScriptFunctionImpl.parse(stylesheetParser, element, baseURI, classLoader);
        }
    }

    public static Object evaluateCommandLineScripts(List scripts, ClassLoader classLoader) throws XSLException, IOException {
        if (!ECMAScriptFunction.isECMAScriptAvailable()) {
            throw new ExtensionException("ee4");
        }
        return ECMAScriptFunctionImpl.evaluateCommandLineScripts(scripts, classLoader);
    }

    public static boolean isECMAScriptAvailable() {
        if (!checkedRhinoAvailable) {
            checkedRhinoAvailable = true;
            try {
                if (Class.forName("com.novell.soa.script.mozilla.javascript.Context") != null) {
                    rhinoAvailable = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return rhinoAvailable;
    }

    static {
        scriptAttr = new AttrDef[]{new AttrDef("href", 0, null, 9), new AttrDef("encoding", 0, null, 9)};
        optArgs = new Class[50];
        for (int i = 0; i < optArgs.length; ++i) {
            ECMAScriptFunction.optArgs[i] = defaultParameterType;
        }
    }
}

