/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.extensions;

import com.novell.soa.script.mozilla.javascript.Context;
import com.novell.soa.script.mozilla.javascript.Function;
import com.novell.soa.script.mozilla.javascript.ImporterTopLevel;
import com.novell.soa.script.mozilla.javascript.RhinoException;
import com.novell.soa.script.mozilla.javascript.Scriptable;
import com.novell.soa.script.mozilla.javascript.ScriptableObject;
import com.novell.soa.script.mozilla.javascript.Wrapper;
import com.novell.xml.dom.NodeImpl;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.FunctionSignature;
import com.novell.xml.xpath.XPathConversionException;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathParserException;
import com.novell.xml.xpath.XPathUtil;
import com.novell.xsl.XSLException;
import com.novell.xsl.extensions.ECMAScriptFunction;
import com.novell.xsl.extensions.JavaInstance;
import com.novell.xsl.extensions.JavaObject;
import com.novell.xsl.extensions.JavaVoid;
import com.novell.xsl.parser.AttrDef;
import com.novell.xsl.parser.StylesheetParser;
import com.novell.xsl.parser.XSLTParserException;
import com.novell.xsl.util.Util;
import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class ECMAScriptFunctionImpl
extends ECMAScriptFunction {
    public static final String ECMASCRIPT_EXTENSION_FUNCTION_NAMESPACE = "http://www.novell.com/nxsl/ecmascript";
    public static final String ECMASCRIPT_SCOPE_PROPERTY = "com.novell.xsl.extensions.ECMAScriptFunction.scope";
    protected static final Class undefinedReturnType = XPathUtil.doGetClass("com.novell.soa.script.mozilla.javascript.Undefined");
    protected static final Class nativeReturnType = XPathUtil.doGetClass("com.novell.soa.script.mozilla.javascript.NativeJavaObject");
    protected ClassLoader classLoader = null;

    public ECMAScriptFunctionImpl(ExpandedQName name, ClassLoader classLoader) {
        super(new FunctionSignature(name, defaultReturnType, FunctionSignature.getContextArgTypes(), optArgs));
        this.classLoader = classLoader;
    }

    public ExpressionValue invoke(Object[] args) throws XPathEvaluationException {
        try {
            ExpressionContext context = (ExpressionContext)args[1];
            Context jsContext = Context.enter();
            if (this.classLoader != null) {
                jsContext.setApplicationClassLoader(this.classLoader);
            }
            Scriptable scope = ECMAScriptFunctionImpl.getScope(context, jsContext);
            String functionName = this.getSignature().getName().getLocalPart();
            Function function = (Function)ScriptableObject.getProperty((Scriptable)scope, (String)functionName);
            Object[] jsArgs = new Object[args.length - 2];
            for (int i = 0; i < jsArgs.length; ++i) {
                jsArgs[i] = ECMAScriptFunctionImpl.expressionValueToECMAScript((ExpressionValue)args[i + 2], scope);
            }
            Object result = null;
            result = functionName.equals("eval") ? jsContext.evaluateString(scope, jsArgs[0].toString(), "nxsl", 0, null) : function.call(jsContext, scope, scope, jsArgs);
            ExpressionValue expressionValue = ECMAScriptFunctionImpl.ECMAScriptToExpressionValue(result);
            return expressionValue;
        }
        catch (ClassCastException e) {
            String message = new XPathParserException("pe12", this.getSignature().getName().getQName()).getMessage();
            throw new XPathEvaluationException(message);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new XPathEvaluationException("pe9");
        }
        catch (NoClassDefFoundError ncdfe) {
            String message = new XPathParserException("pe12", this.getSignature().getName().getQName()).getMessage();
            throw new XPathEvaluationException(message);
        }
        catch (RhinoException re) {
            throw new XPathEvaluationException(re.getMessage());
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean available(ExpressionContext eContext) {
        try {
            String functionName;
            Scriptable scope;
            Function function;
            Context jsContext = Context.enter();
            if (this.classLoader != null) {
                jsContext.setApplicationClassLoader(this.classLoader);
            }
            boolean bl = (function = (Function)ScriptableObject.getProperty((Scriptable)(scope = ECMAScriptFunctionImpl.getScope(eContext, jsContext)), (String)(functionName = this.getSignature().getName().getLocalPart()))) != null;
            return bl;
        }
        catch (Exception exception) {
        }
        finally {
            Context.exit();
        }
        return false;
    }

    public static Object expressionValueToECMAScript(ExpressionValue expressionValue, Scriptable scope) throws XPathConversionException {
        int valueType = expressionValue.getValueType();
        switch (valueType) {
            case 0: {
                return Context.javaToJS((Object)expressionValue.getBooleanValue(), (Scriptable)scope);
            }
            case 1: {
                return Context.javaToJS((Object)new Double(expressionValue.getNumberValue()), (Scriptable)scope);
            }
            case 2: {
                return Context.javaToJS((Object)expressionValue.getStringValue(), (Scriptable)scope);
            }
            case 3: {
                return Context.javaToJS((Object)expressionValue.getNodeSetValue(), (Scriptable)scope);
            }
        }
        return Context.javaToJS((Object)expressionValue.getNativeValue(), (Scriptable)scope);
    }

    public static ExpressionValue ECMAScriptToExpressionValue(Object value) {
        if (value != null) {
            while (value instanceof Wrapper) {
                value = ((Wrapper)value).unwrap();
            }
            Class<?> baseRetType = value.getClass();
            if (baseRetType == undefinedReturnType) {
                return new JavaVoid();
            }
            Class wrappedReturn = JavaInstance.getReturnType(baseRetType);
            try {
                if (wrappedReturn != baseRetType) {
                    ExpressionValue returnWrapper = (ExpressionValue)wrappedReturn.newInstance();
                    returnWrapper.castFrom(value);
                    if (returnWrapper instanceof JavaObject) {
                        ((JavaObject)returnWrapper).setWrappedType(baseRetType);
                    }
                    return returnWrapper;
                }
                return (ExpressionValue)value;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return new JavaObject(value);
    }

    public static void parse(StylesheetParser stylesheetParser, Element element, URL baseURI, ClassLoader classLoader) throws XSLTParserException {
        Object[] attr = AttrDef.parseAttributes(stylesheetParser, element, scriptAttr);
        String href = (String)attr[0];
        String encoding = (String)attr[1];
        Node child = element.getFirstChild();
        if (href != null && child != null) {
            stylesheetParser.reportError(element, "spe24");
            return;
        }
        try {
            if (child != null) {
                int line = 1;
                String string = href = baseURI != null ? baseURI.toString() : "";
                if (element instanceof NodeImpl) {
                    line = ((NodeImpl)((Object)element)).getLineNumber();
                }
                StringBuffer buf = new StringBuffer();
                while (child != null) {
                    switch (child.getNodeType()) {
                        case 1: {
                            stylesheetParser.reportError(element, child, "spe4");
                            break;
                        }
                        case 8: {
                            buf.append(((Comment)child).getData().replaceAll("[^\n]", ""));
                            break;
                        }
                        case 7: {
                            buf.append(((ProcessingInstruction)child).getData().replaceAll("[^\n]", ""));
                            break;
                        }
                        case 3: 
                        case 4: {
                            buf.append(child.getNodeValue());
                            break;
                        }
                        case 6: {
                            buf.append(Util.getXSLStringValue(child));
                            break;
                        }
                        default: {
                            stylesheetParser.reportError(element, child, "spe4");
                        }
                    }
                    child = child.getNextSibling();
                }
                ECMAScriptFunctionImpl.evaluate(stylesheetParser.getStylesheet().getContext(), buf.toString(), href, line, classLoader);
            } else {
                URL externalScript = baseURI != null ? new URL(baseURI, href) : new URL(href);
                ECMAScriptFunctionImpl.evaluate(stylesheetParser.getStylesheet().getContext(), externalScript, encoding, classLoader);
            }
        }
        catch (Exception e) {
            stylesheetParser.reportError(element, e.toString());
        }
    }

    public static Scriptable createScope(Context jsContext) {
        return new ImporterTopLevel(jsContext);
    }

    public static Scriptable getScope(ExpressionContext eContext, Context jsContext) {
        Scriptable scope = (Scriptable)eContext.getProperty(ECMASCRIPT_SCOPE_PROPERTY);
        if (scope == null) {
            scope = ECMAScriptFunctionImpl.createScope(jsContext);
            eContext.setProperty(ECMASCRIPT_SCOPE_PROPERTY, scope);
        }
        return scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object evaluate(ExpressionContext eContext, String script, String uri, int line, ClassLoader classLoader) {
        try {
            Object result;
            Context jsContext = Context.enter();
            if (classLoader != null) {
                jsContext.setApplicationClassLoader(classLoader);
            }
            Scriptable scope = ECMAScriptFunctionImpl.getScope(eContext, jsContext);
            Object object = result = jsContext.evaluateString(scope, script, uri, line, null);
            return object;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object evaluate(ExpressionContext eContext, URL externalScript, String encoding, ClassLoader classLoader) throws IOException {
        Object object;
        InputStream inStream = null;
        try {
            Object result;
            String contentType;
            Context jsContext = Context.enter();
            if (classLoader != null) {
                jsContext.setApplicationClassLoader(classLoader);
            }
            Scriptable scope = ECMAScriptFunctionImpl.getScope(eContext, jsContext);
            URLConnection connection = externalScript.openConnection();
            inStream = connection.getInputStream();
            if (encoding == null && (contentType = connection.getContentType()) != null) {
                try {
                    DataFlavor flavor = new DataFlavor(contentType);
                    encoding = flavor.getParameter("charset");
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            InputStreamReader reader = encoding != null ? new InputStreamReader(inStream, encoding) : new InputStreamReader(inStream);
            object = result = jsContext.evaluateReader(scope, (Reader)reader, externalScript.toString(), 1, null);
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            block7: {
                Object var12_13 = null;
                Context.exit();
                if (inStream == null) break block7;
                inStream.close();
            }
            throw throwable;
        }
        Context.exit();
        if (inStream != null) {
            inStream.close();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object evaluateCommandLineScripts(List scripts, ClassLoader classLoader) throws XSLException, IOException {
        Scriptable scope = null;
        InputStream inStream = null;
        try {
            Context jsContext = Context.enter();
            if (classLoader != null) {
                jsContext.setApplicationClassLoader(classLoader);
            }
            scope = ECMAScriptFunctionImpl.createScope(jsContext);
            for (int i = 0; i < scripts.size(); ++i) {
                Object var12_14;
                try {
                    URL externalScript = new URL((String)scripts.get(i));
                    URLConnection connection = externalScript.openConnection();
                    inStream = connection.getInputStream();
                    String encoding = null;
                    String contentType = connection.getContentType();
                    if (contentType != null) {
                        try {
                            DataFlavor flavor = new DataFlavor(contentType);
                            encoding = flavor.getParameter("charset");
                        }
                        catch (ClassNotFoundException e) {
                            // empty catch block
                        }
                    }
                    InputStreamReader reader = encoding != null ? new InputStreamReader(inStream, encoding) : new InputStreamReader(inStream);
                    jsContext.evaluateReader(scope, (Reader)reader, externalScript.toString(), 1, null);
                    var12_14 = null;
                    if (inStream == null) continue;
                }
                catch (Throwable throwable) {
                    var12_14 = null;
                    if (inStream != null) {
                        inStream.close();
                        inStream = null;
                    }
                    throw throwable;
                }
                inStream.close();
                inStream = null;
                {
                    continue;
                }
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new XSLException(e.toString());
        }
        finally {
            Context.exit();
        }
        return scope;
    }
}

