/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.extensions;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.Function;
import com.novell.xml.xpath.FunctionLibraryImpl;
import com.novell.xml.xpath.FunctionSignature;
import com.novell.xml.xpath.XPathParserException;
import com.novell.xml.xpath.functions.XPathBuiltIns;
import com.novell.xsl.extensions.BadFunction;
import com.novell.xsl.extensions.ECMAScriptFunction;
import com.novell.xsl.extensions.JavaConstructor;
import com.novell.xsl.extensions.JavaMethod;
import com.novell.xsl.extensions.functions.NxslBuiltIns;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class ExtensibleFunctionLibrary
extends FunctionLibraryImpl {
    protected ClassLoader loader = null;

    public ExtensibleFunctionLibrary() {
        XPathBuiltIns.addBuiltIns(this);
        NxslBuiltIns.addBuiltIns(this);
    }

    public ExtensibleFunctionLibrary(ClassLoader loader) {
        XPathBuiltIns.addBuiltIns(this);
        NxslBuiltIns.addBuiltIns(this);
        this.loader = loader;
    }

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public Function getFunction(ExpandedQName name) throws XPathParserException {
        Function function = this.findFunction(name);
        if (function != null) {
            return function;
        }
        try {
            String namespaceURI = name.getNamespaceURI();
            if (namespaceURI.startsWith("http://www.novell.com/nxsl/java/")) {
                String className = namespaceURI.substring("http://www.novell.com/nxsl/java/".length(), namespaceURI.length());
                Class<?> objClass = this.loader == null ? Class.forName(className) : this.loader.loadClass(className);
                String memberName = name.getLocalPart();
                if (memberName.equals("new")) {
                    Constructor[] constructors = objClass.getConstructors();
                    if (constructors.length != 0) {
                        function = this.doConstructors(constructors, name, objClass);
                    }
                } else {
                    Method[] methods = objClass.getMethods();
                    if (methods.length != 0) {
                        function = this.doMethods(methods, name, objClass);
                    }
                }
                if (function != null) {
                    this.addFunction(function);
                    return function;
                }
                return super.getFunction(name);
            }
            if (namespaceURI.equals("http://www.novell.com/nxsl/ecmascript")) {
                function = ECMAScriptFunction.create(name, this.loader);
                this.addFunction(function);
                return function;
            }
            if (name.getPrefix() != null && name.getPrefix().length() > 0) {
                try {
                    throw new XPathParserException("pe12", name.getQName());
                }
                catch (XPathParserException e) {
                    return new BadFunction(e.getMessage());
                }
            }
            throw new XPathParserException("pe12", name.getQName());
        }
        catch (ClassNotFoundException e) {
            try {
                throw new XPathParserException("pe12", name.getQName());
            }
            catch (XPathParserException e2) {
                function = new BadFunction(e2.getMessage());
                return function;
            }
        }
    }

    private Function doConstructors(Constructor[] constructors, ExpandedQName name, Class javaClass) {
        FunctionSignature signature = new FunctionSignature(name, javaClass);
        return new JavaConstructor(signature, constructors);
    }

    private Function doMethods(Method[] methods, ExpandedQName name, Class methodClass) {
        String methodName = name.getLocalPart();
        ArrayList<Method> list = new ArrayList<Method>();
        for (int i = 0; i < methods.length; ++i) {
            if (!methodName.equals(methods[i].getName())) continue;
            list.add(methods[i]);
        }
        if (list.size() == 0) {
            return null;
        }
        methods = new Method[list.size()];
        list.toArray(methods);
        Class<?> retType = methods[0].getReturnType();
        FunctionSignature signature = new FunctionSignature(name, retType);
        return new JavaMethod(signature, methods, methodClass);
    }

    public boolean isFunctionAvailable(ExpressionContext context, ExpandedQName name) {
        Function function = this.findFunction(name);
        if (function == null) {
            return false;
        }
        if (function instanceof ECMAScriptFunction) {
            return ((ECMAScriptFunction)function).available(context);
        }
        return this.findFunction(name) != null;
    }
}

