/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.extensions;

import com.novell.xml.xpath.ArgumentList;
import com.novell.xml.xpath.Function;
import com.novell.xml.xpath.FunctionSignature;
import com.novell.xml.xpath.XPathParserException;
import com.novell.xsl.extensions.BadFunction;
import com.novell.xsl.extensions.ExtensionException;
import com.novell.xsl.extensions.JavaConstructorInstance;
import com.novell.xsl.extensions.JavaMember;
import java.lang.reflect.Constructor;
import java.util.ArrayList;

public class JavaConstructor
extends JavaMember {
    private Constructor[] constructors;

    public JavaConstructor(FunctionSignature signature, Constructor[] constructors) {
        super(signature);
        this.constructors = constructors;
    }

    public Function getInstance(ArgumentList args) throws XPathParserException {
        ArrayList<Constructor> list = new ArrayList<Constructor>();
        for (int i = 0; i < this.constructors.length; ++i) {
            if (args.count() != this.constructors[i].getParameterTypes().length) continue;
            list.add(this.constructors[i]);
        }
        if (list.size() == 1) {
            return new JavaConstructorInstance(this.getSignature(), (Constructor)list.get(0));
        }
        if (list.size() > 1) {
            int bestPick = 0;
            int maxWeight = Integer.MIN_VALUE;
            boolean equalWeight = false;
            for (int i = 0; i < list.size(); ++i) {
                Class<?>[] params = ((Constructor)list.get(i)).getParameterTypes();
                int weight = 0;
                for (int j = 0; j < params.length; ++j) {
                    weight += this.weightParam(params[j], args.getArgument(j));
                }
                if (weight > maxWeight) {
                    maxWeight = weight;
                    bestPick = i;
                    equalWeight = false;
                    continue;
                }
                if (weight != maxWeight) continue;
                equalWeight = true;
            }
            if (equalWeight) {
                return new BadFunction(ExtensionException.constructMessage("ee1", new String[]{this.getSignature().getName().getQName() + "(" + args.toString() + ")"}));
            }
            return new JavaConstructorInstance(this.getSignature(), (Constructor)list.get(bestPick));
        }
        return new BadFunction(ExtensionException.constructMessage("ee3", new String[]{this.getSignature().getName().getQName() + "(" + args.toString() + ")"}));
    }
}

