/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.extensions;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.FunctionSignature;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.extensions.JavaInstance;
import com.novell.xsl.extensions.JavaObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class JavaConstructorInstance
extends JavaInstance {
    private Constructor constructor;
    private Class constructorClass;
    private Object[] frame;

    public JavaConstructorInstance(FunctionSignature baseSignature, Constructor constructor) {
        super(JavaConstructorInstance.constructSignature(baseSignature.getName(), constructor));
        this.constructor = constructor;
        Class wrappedReturn = JavaConstructorInstance.getReturnType(constructor.getDeclaringClass());
        try {
            if (wrappedReturn != constructor.getDeclaringClass()) {
                this.returnWrapper = (ExpressionValue)wrappedReturn.newInstance();
                if (this.returnWrapper instanceof JavaObject) {
                    ((JavaObject)this.returnWrapper).setWrappedType(constructor.getDeclaringClass());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        this.constructorClass = constructor.getDeclaringClass();
        this.frame = new Object[this.getSignature().getRequiredArgs().length];
    }

    public ExpressionValue invoke(Object[] args) throws XPathEvaluationException {
        String errorMessage;
        try {
            for (int i = 0; i < this.frame.length; ++i) {
                this.frame[i] = args[i] instanceof JavaObject ? ((JavaObject)args[i]).getObject() : args[i];
            }
            Object ret = this.constructor.newInstance(this.frame);
            if (this.returnWrapper != null) {
                this.returnWrapper.castFrom(ret);
                return this.returnWrapper;
            }
            return (ExpressionValue)ret;
        }
        catch (InstantiationException e) {
            errorMessage = e.getMessage();
        }
        catch (InvocationTargetException e) {
            errorMessage = e.getTargetException().toString();
        }
        catch (IllegalAccessException e) {
            errorMessage = e.toString();
        }
        catch (IllegalArgumentException e) {
            errorMessage = e.toString();
        }
        String[] parms = new String[]{this.getSignature().getName().getQName(), errorMessage};
        throw new XPathEvaluationException("ee2", parms);
    }

    private static FunctionSignature constructSignature(ExpandedQName name, Constructor constructor) {
        Class wrappedReturn = JavaConstructorInstance.getReturnType(constructor.getDeclaringClass());
        Class[] types = constructor.getParameterTypes();
        return new FunctionSignature(name, wrappedReturn, types);
    }
}

