/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.extensions;

import com.novell.xml.xpath.BooleanValue;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.Function;
import com.novell.xml.xpath.FunctionSignature;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.NumberValue;
import com.novell.xml.xpath.StringValue;
import com.novell.xml.xpath.XPathUtil;
import com.novell.xsl.extensions.JavaObject;
import com.novell.xsl.extensions.JavaVoid;

public abstract class JavaInstance
extends Function {
    protected ExpressionValue returnWrapper = null;
    protected static final Class interfaceExpressionValue = XPathUtil.doGetClass("com.novell.xml.xpath.ExpressionValue");
    protected static final Class interfaceNode = XPathUtil.doGetClass("org.w3c.dom.Node");
    protected static final Class classString = XPathUtil.doGetClass("java.lang.String");
    protected static final Class classNumber = XPathUtil.doGetClass("java.lang.Number");
    protected static final Class classBoolean = XPathUtil.doGetClass("java.lang.Boolean");

    protected JavaInstance(FunctionSignature signature) {
        super(signature);
    }

    public String toString() {
        return this.getSignature().getName().getQName();
    }

    public Class getWrappedResultType() {
        if (this.returnWrapper == null || !(this.returnWrapper instanceof JavaObject)) {
            return this.getSignature().getReturnType();
        }
        return ((JavaObject)this.returnWrapper).getWrappedType();
    }

    public static Class getReturnType(Class baseRetType) {
        if (interfaceExpressionValue.isAssignableFrom(baseRetType)) {
            return baseRetType;
        }
        if (Void.TYPE.isAssignableFrom(baseRetType)) {
            return JavaVoid.getArgType();
        }
        if (Boolean.TYPE.isAssignableFrom(baseRetType) || classBoolean.isAssignableFrom(baseRetType)) {
            return BooleanValue.getArgType();
        }
        if (baseRetType.isPrimitive() || classNumber.isAssignableFrom(baseRetType)) {
            return NumberValue.getArgType();
        }
        if (classString.isAssignableFrom(baseRetType)) {
            return StringValue.getArgType();
        }
        if (interfaceNode.isAssignableFrom(baseRetType)) {
            return NodeSet.getArgType();
        }
        return JavaObject.getArgType();
    }
}

