/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.extensions;

import com.novell.xml.xpath.BooleanValue;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.Function;
import com.novell.xml.xpath.FunctionCall;
import com.novell.xml.xpath.FunctionSignature;
import com.novell.xml.xpath.NodeSetExpr;
import com.novell.xml.xpath.NumberValue;
import com.novell.xml.xpath.StringValue;
import com.novell.xml.xpath.VariableReference;
import com.novell.xml.xpath.XPathUtil;
import com.novell.xsl.extensions.JavaInstance;
import com.novell.xsl.extensions.JavaObject;

public abstract class JavaMember
extends Function {
    protected static final Class interfaceExpressionValue = XPathUtil.doGetClass("com.novell.xml.xpath.ExpressionValue");
    protected static final Class classString = XPathUtil.doGetClass("java.lang.String");
    protected static final Class classNumber = XPathUtil.doGetClass("java.lang.Number");
    protected static final Class classBoolean = XPathUtil.doGetClass("java.lang.Boolean");
    protected static final Class interfaceNode = XPathUtil.doGetClass("org.w3c.dom.Node");

    public JavaMember(FunctionSignature signature) {
        super(signature);
    }

    protected int weightParam(Class formalType, Expression argument) {
        Class actualType = argument instanceof FunctionCall && ((FunctionCall)argument).getFunction() instanceof JavaInstance ? ((JavaInstance)((FunctionCall)argument).getFunction()).getWrappedResultType() : argument.getResultType();
        if (formalType.isAssignableFrom(actualType)) {
            if (formalType.getName().equals(actualType.getName())) {
                return 6;
            }
            return 4;
        }
        if (Boolean.TYPE.isAssignableFrom(formalType) && classBoolean.isAssignableFrom(formalType)) {
            if (BooleanValue.getArgType().isAssignableFrom(actualType)) {
                return 6;
            }
            return 2;
        }
        if (formalType.isPrimitive() || classNumber.isAssignableFrom(formalType)) {
            if (NumberValue.getArgType().isAssignableFrom(actualType)) {
                if (Double.TYPE.isAssignableFrom(formalType)) {
                    return 6;
                }
                if (Long.TYPE.isAssignableFrom(formalType)) {
                    return 5;
                }
                if (Integer.TYPE.isAssignableFrom(formalType)) {
                    return 4;
                }
                return 3;
            }
            return 2;
        }
        if (classString.isAssignableFrom(formalType)) {
            if (StringValue.getArgType().isAssignableFrom(actualType)) {
                return 6;
            }
            return 2;
        }
        if (formalType.isAssignableFrom(interfaceExpressionValue)) {
            return 2;
        }
        if (interfaceExpressionValue.isAssignableFrom(actualType) && interfaceExpressionValue.isAssignableFrom(formalType)) {
            return 2;
        }
        if (actualType.isAssignableFrom(JavaObject.getArgType())) {
            return 1;
        }
        if (argument instanceof VariableReference) {
            return 0;
        }
        if (argument instanceof NodeSetExpr && interfaceNode.isAssignableFrom(formalType)) {
            return 2;
        }
        return -1;
    }
}

