/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.extensions;

import com.novell.xml.xpath.ArgumentList;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.Function;
import com.novell.xml.xpath.FunctionSignature;
import com.novell.xml.xpath.XPathParserException;
import com.novell.xsl.extensions.BadFunction;
import com.novell.xsl.extensions.ExtensionException;
import com.novell.xsl.extensions.JavaMember;
import com.novell.xsl.extensions.JavaMethodInstance;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public class JavaMethod
extends JavaMember {
    private Method[] methods;
    private Class _class;

    public JavaMethod(FunctionSignature signature, Method[] methods, Class methodClass) {
        super(signature);
        this.methods = methods;
        this._class = methodClass;
    }

    public Function getInstance(ArgumentList args) throws XPathParserException {
        ArrayList<Method> list = new ArrayList<Method>();
        Expression thisArg = args.getArgument(0);
        for (int i = 0; i < this.methods.length; ++i) {
            Class<?>[] methodParams = this.methods[i].getParameterTypes();
            int startArg = 0;
            if (!Modifier.isStatic(this.methods[i].getModifiers())) {
                if (args.count() < 1 || this.weightParam(this.methods[i].getDeclaringClass(), thisArg) < 0) continue;
                startArg = 1;
            }
            if (args.count() - startArg != methodParams.length) continue;
            list.add(this.methods[i]);
        }
        if (list.size() == 1) {
            return new JavaMethodInstance(this.getSignature(), (Method)list.get(0));
        }
        if (list.size() > 1) {
            int bestPick = 0;
            int maxWeight = Integer.MIN_VALUE;
            boolean equalWeight = false;
            for (int i = 0; i < list.size(); ++i) {
                Class<?>[] params = ((Method)list.get(i)).getParameterTypes();
                boolean isStatic = Modifier.isStatic(((Method)list.get(i)).getModifiers());
                int weight = isStatic ? 0 : 2;
                int startArg = isStatic ? 0 : 1;
                for (int j = 0; j < params.length; ++j) {
                    weight += this.weightParam(params[j], args.getArgument(j + startArg));
                }
                if (weight > maxWeight) {
                    maxWeight = weight;
                    bestPick = i;
                    equalWeight = false;
                    continue;
                }
                if (weight != maxWeight || JavaMethod.methodsEqual((Method)list.get(bestPick), (Method)list.get(i))) continue;
                equalWeight = true;
            }
            if (equalWeight) {
                return new BadFunction(ExtensionException.constructMessage("ee2", new String[]{this.getSignature().getName().getQName() + "(" + args.toString() + ")"}));
            }
            Method method = this.getMostDerivedMethod((Method)list.get(bestPick));
            if (method == null) {
                return new BadFunction(ExtensionException.constructMessage("ee3", new String[]{this.getSignature().getName().getQName() + "(" + args.toString() + ")"}));
            }
            return new JavaMethodInstance(this.getSignature(), method);
        }
        return new BadFunction(ExtensionException.constructMessage("ee3", new String[]{this.getSignature().getName().getQName() + "(" + args.toString() + ")"}));
    }

    protected static boolean methodsEqual(Method m1, Method m2) {
        Class<?>[] m2Params;
        Class<?>[] m1Params = m1.getParameterTypes();
        if (m1Params.length != (m2Params = m2.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < m1Params.length; ++i) {
            if (m1Params[i].getName().equals(m2Params[i].getName())) continue;
            return false;
        }
        return true;
    }

    protected Method getMostDerivedMethod(Method method) throws XPathParserException {
        try {
            return this._class.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

