/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.extensions;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.FunctionSignature;
import com.novell.xml.xpath.XPathConversionException;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.extensions.JavaInstance;
import com.novell.xsl.extensions.JavaObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class JavaMethodInstance
extends JavaInstance {
    private Method method;
    private Class methodClass;
    private boolean isStatic;
    private Object[] frame;

    public JavaMethodInstance(FunctionSignature baseSignature, Method method) {
        super(JavaMethodInstance.constructSignature(baseSignature.getName(), method));
        this.method = method;
        this.methodClass = method.getDeclaringClass();
        this.isStatic = Modifier.isStatic(method.getModifiers());
        this.frame = !this.isStatic ? new Object[this.getSignature().getRequiredArgs().length - 1] : new Object[this.getSignature().getRequiredArgs().length];
        Class wrappedReturn = JavaMethodInstance.getReturnType(method.getReturnType());
        try {
            if (wrappedReturn != method.getReturnType()) {
                this.returnWrapper = (ExpressionValue)wrappedReturn.newInstance();
                if (this.returnWrapper instanceof JavaObject) {
                    ((JavaObject)this.returnWrapper).setWrappedType(method.getReturnType());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExpressionValue invoke(Object[] args) throws XPathEvaluationException {
        String errorMessage;
        try {
            Object ret;
            block11: {
                block12: {
                    if (this.isStatic) break block12;
                    for (int i = 0; i < this.frame.length; ++i) {
                        this.frame[i] = args[i + 1] != null && args[i + 1] instanceof JavaObject ? ((JavaObject)args[i + 1]).getObject() : args[i + 1];
                    }
                    if (args[0] != null && this.methodClass.isInstance(args[0])) {
                        ret = this.method.invoke(args[0], this.frame);
                        break block11;
                    } else if (args[0] != null && args[0] instanceof JavaObject && this.methodClass.isInstance(((JavaObject)args[0]).getObject())) {
                        ret = this.method.invoke(((JavaObject)args[0]).getObject(), this.frame);
                        break block11;
                    } else {
                        String[] parms = new String[]{args[0] == null ? null : (args[0] instanceof JavaObject ? ((JavaObject)args[0]).getObject().getClass().getName() : args[0].getClass().getName()), this.methodClass.getName()};
                        throw new XPathConversionException("vce6", parms);
                    }
                }
                for (int i = 0; i < this.frame.length; ++i) {
                    this.frame[i] = args[i] != null && args[i] instanceof JavaObject ? ((JavaObject)args[i]).getObject() : args[i];
                }
                ret = this.method.invoke(null, this.frame);
            }
            if (this.returnWrapper != null) {
                this.returnWrapper.castFrom(ret);
                return this.returnWrapper;
            }
            return (ExpressionValue)ret;
        }
        catch (InvocationTargetException e) {
            errorMessage = e.getTargetException().toString();
        }
        catch (IllegalAccessException e) {
            errorMessage = e.toString();
        }
        catch (IllegalArgumentException e) {
            errorMessage = e.toString();
        }
        String[] parms = new String[]{this.getSignature().getName().getQName(), errorMessage};
        throw new XPathEvaluationException("ee2", parms);
    }

    private static FunctionSignature constructSignature(ExpandedQName name, Method method) {
        Class wrappedReturn = JavaMethodInstance.getReturnType(method.getReturnType());
        Class<?>[] types = method.getParameterTypes();
        boolean isStatic = Modifier.isStatic(method.getModifiers());
        Class[] reqArgs = new Class[types.length + (isStatic ? 0 : 1)];
        if (!isStatic) {
            reqArgs[0] = method.getDeclaringClass();
            for (int i = 1; i < reqArgs.length; ++i) {
                reqArgs[i] = types[i - 1];
            }
        } else {
            for (int i = 0; i < reqArgs.length; ++i) {
                reqArgs[i] = types[i];
            }
        }
        return new FunctionSignature(name, wrappedReturn, reqArgs);
    }
}

