/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.extensions.functions;

import com.novell.xml.dom.DocumentFactory;
import com.novell.xml.dom.DocumentFragmentImpl;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.Function;
import com.novell.xml.xpath.FunctionSignature;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.Stylesheet;
import com.novell.xsl.process.ResultTreeFragment;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class nxslNodeSet
extends Function {
    public nxslNodeSet() {
        super(nxslNodeSet.createSignature(Stylesheet.NXSL_NAMESPACE));
    }

    protected nxslNodeSet(NamespaceName namespace) {
        super(nxslNodeSet.createSignature(namespace));
    }

    public ExpressionValue invoke(Object[] args) throws XPathEvaluationException {
        try {
            NodeSet result;
            ExpressionValue arg = (ExpressionValue)args[0];
            if (arg instanceof ResultTreeFragment) {
                ResultTreeFragment rtf = (ResultTreeFragment)arg;
                result = new NodeSet();
                Node root = rtf.getRoot();
                if (root instanceof DocumentFragmentImpl) {
                    ((DocumentFragmentImpl)root).updateDocumentOrder();
                }
                result.add(root);
            } else if (arg instanceof NodeSet) {
                result = (NodeSet)arg;
            } else {
                Document document = DocumentFactory.newDocument();
                Text text = document.createTextNode(arg.getStringValue());
                result = new NodeSet();
                result.add(text);
            }
            return result;
        }
        catch (ClassCastException e) {
            throw new XPathEvaluationException("pe11");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new XPathEvaluationException("pe9");
        }
    }

    public String toString() {
        return "node-set";
    }

    protected static FunctionSignature createSignature(NamespaceName namespace) {
        try {
            Class[] reqArgs = new Class[]{Class.forName("com.novell.xml.xpath.ExpressionValue")};
            return new FunctionSignature(new ExpandedQName(namespace, "node-set"), NodeSet.getArgType(), reqArgs);
        }
        catch (ClassNotFoundException e) {
            throw new Error(e.getLocalizedMessage());
        }
    }
}

