/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.functions;

import com.novell.xml.dom.NodeImpl;
import com.novell.xml.parser.XMLParser;
import com.novell.xml.parser.XMLParserFactory;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.Function;
import com.novell.xml.xpath.FunctionSignature;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathResetCache;
import com.novell.xml.xpath.XPathResetRegistrar;
import com.novell.xml.xpath.XPathUtil;
import com.novell.xsl.process.Context;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class xsltDocument
extends Function
implements XPathResetCache {
    private XMLParser xmlParser = null;
    private StringBuffer errorBuffer = null;
    private Map documentMap = null;
    private Document cachedStylesheet = null;

    public xsltDocument() {
        super(xsltDocument.createSignature());
    }

    public ExpressionValue invoke(Object[] args) throws XPathEvaluationException {
        try {
            Context context = (Context)args[1];
            ExpressionValue uriArg = (ExpressionValue)args[2];
            NodeSet relativeTo = args.length > 3 ? ((ExpressionValue)args[3]).getNodeSetValue() : null;
            NodeSet result = new NodeSet();
            if (this.documentMap == null) {
                this.documentMap = new HashMap();
            }
            if (this.xmlParser == null) {
                this.xmlParser = XMLParserFactory.newParser();
            }
            if (this.errorBuffer != null) {
                this.errorBuffer.setLength(0);
            }
            if (uriArg.getValueType() == 3) {
                NodeSet uriSet = uriArg.getNodeSetValue();
                Node node = uriSet.first();
                while (node != null) {
                    String uri = XPathUtil.getNodeValue(node);
                    boolean isStylesheet = uri != null && uri.length() == 0;
                    URL url = this.getURL(uri, relativeTo, node, context);
                    Document doc = (Document)this.documentMap.get(url.toString());
                    if (doc != null || isStylesheet && (doc = this.cachedStylesheet) != null) {
                        result.add(doc);
                    } else {
                        this.xmlParser.setContextURI(url.toString());
                        doc = this.xmlParser.parse(url.openStream());
                        if (this.xmlParser.anyErrors()) {
                            this.packageErrors(this.xmlParser);
                        } else {
                            if (context.getStylesheet().getXmlHook() != null) {
                                doc = context.getStylesheet().getXmlHook().processDocument(doc);
                            }
                            result.add(doc);
                            context.addBaseURI(doc, url);
                            if (isStylesheet) {
                                this.cachedStylesheet = doc;
                            } else {
                                this.documentMap.put(url.toString(), doc);
                            }
                        }
                    }
                    node = uriSet.next();
                }
            } else {
                String uri = uriArg.getStringValue();
                boolean isStylesheet = uri != null && uri.length() == 0;
                URL url = this.getURL(uri, relativeTo, context.getCurrentStylesheetNode(), context);
                Document doc = (Document)this.documentMap.get(url.toString());
                if (doc != null || isStylesheet && (doc = this.cachedStylesheet) != null) {
                    result.add(doc);
                } else {
                    this.xmlParser.setContextURI(url.toString());
                    doc = this.xmlParser.parse(url.openStream());
                    if (this.xmlParser.anyErrors()) {
                        this.packageErrors(this.xmlParser);
                    } else {
                        if (context.getStylesheet().getXmlHook() != null) {
                            doc = context.getStylesheet().getXmlHook().processDocument(doc);
                        }
                        result.add(doc);
                        context.addBaseURI(doc, url);
                        if (isStylesheet) {
                            this.cachedStylesheet = doc;
                        } else {
                            this.documentMap.put(url.toString(), doc);
                        }
                    }
                }
            }
            if (this.errorBuffer != null && this.errorBuffer.length() > 0) {
                throw new XPathEvaluationException(this.toString() + "(): " + this.errorBuffer.toString());
            }
            return result;
        }
        catch (ClassCastException e) {
            throw new XPathEvaluationException("pe11");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new XPathEvaluationException("pe9");
        }
        catch (MalformedURLException e) {
            throw new XPathEvaluationException(this.toString() + "(): " + e.toString());
        }
        catch (IOException e) {
            throw new XPathEvaluationException(this.toString() + "(): " + e.toString());
        }
        catch (Exception e) {
            throw new XPathEvaluationException(this.toString() + "(): " + e.toString());
        }
    }

    private URL getURL(String uri, NodeSet relativeTo, Node contextNode, Context context) throws MalformedURLException {
        contextNode = relativeTo == null ? contextNode : relativeTo.first();
        String baseString = null;
        if (contextNode instanceof NodeImpl) {
            baseString = ((NodeImpl)contextNode).getBaseURI();
        }
        URL baseURI = baseString != null && baseString.length() > 0 ? new URL(baseString) : context.getBaseURI(contextNode);
        if (uri.length() > 0) {
            if (baseURI != null) {
                return new URL(baseURI, uri);
            }
            return new URL(uri);
        }
        return baseURI;
    }

    private void packageErrors(XMLParser parser) {
        if (this.errorBuffer == null) {
            this.errorBuffer = new StringBuffer(128);
        }
        this.errorBuffer.append(parser.getErrorMsgString());
    }

    public String toString() {
        return "document";
    }

    public void registerForReset(XPathResetRegistrar registrar) {
        registrar.registerResetCache(this);
    }

    public void resetCache() {
        this.documentMap = null;
    }

    private static FunctionSignature createSignature() {
        try {
            Class[] reqArgs = new Class[]{FunctionSignature.getContextArgTypes()[0], FunctionSignature.getContextArgTypes()[1], Class.forName("com.novell.xml.xpath.ExpressionValue")};
            Class[] optArgs = new Class[]{NodeSet.getArgType()};
            return new FunctionSignature(new ExpandedQName("", "document"), NodeSet.getArgType(), reqArgs, optArgs);
        }
        catch (ClassNotFoundException e) {
            throw new Error(e.getLocalizedMessage());
        }
    }
}

