/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.functions;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.Function;
import com.novell.xml.xpath.FunctionSignature;
import com.novell.xml.xpath.NumberValue;
import com.novell.xml.xpath.StringValue;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.functions.XSLTBuiltIns;
import com.novell.xsl.process.Context;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class xsltFormatNumber
extends Function {
    public xsltFormatNumber() {
        super(xsltFormatNumber.createSignature());
    }

    public ExpressionValue invoke(Object[] args) throws XPathEvaluationException {
        try {
            DecimalFormatSymbols decimalFormat;
            Context context = (Context)args[1];
            double number = ((ExpressionValue)args[2]).getNumberValue();
            String formatString = ((ExpressionValue)args[3]).getStringValue();
            ExpandedQName name = null;
            if (args.length > 4 && args[4] != null) {
                name = context.getExpandedName(((ExpressionValue)args[4]).getStringValue());
            }
            if ((decimalFormat = context.getStylesheet().getDecimalFormat(name)) == null) {
                throw new XPathEvaluationException(this.toString() + ": " + XSLTBuiltIns.constructMessage("fe1", new String[]{name.getQName()}));
            }
            DecimalFormat formatter = new DecimalFormat("", decimalFormat);
            formatter.applyLocalizedPattern(formatString);
            return new StringValue(formatter.format(number));
        }
        catch (ClassCastException e) {
            throw new XPathEvaluationException("pe11");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new XPathEvaluationException("pe9");
        }
        catch (IllegalArgumentException e) {
            throw new XPathEvaluationException(this.toString() + ": " + e.getMessage());
        }
    }

    public String toString() {
        return "format-number";
    }

    private static FunctionSignature createSignature() {
        Class[] reqArgs = new Class[]{FunctionSignature.getContextArgTypes()[0], FunctionSignature.getContextArgTypes()[1], NumberValue.getArgType(), StringValue.getArgType()};
        Class[] optArgs = new Class[]{StringValue.getArgType()};
        return new FunctionSignature(new ExpandedQName("", "format-number"), StringValue.getArgType(), reqArgs, optArgs);
    }
}

