/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.functions;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.Function;
import com.novell.xml.xpath.FunctionSignature;
import com.novell.xml.xpath.NumberValue;
import com.novell.xml.xpath.StringValue;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.Stylesheet;
import java.util.HashMap;
import java.util.Map;

public class xsltSystemProperty
extends Function {
    private static Map xsltMap = null;
    private static Map nxslMap = null;
    private static Object gate = new Object();

    public xsltSystemProperty() {
        super(xsltSystemProperty.createSignature());
    }

    public ExpressionValue invoke(Object[] args) throws XPathEvaluationException {
        try {
            ExpressionValue result = null;
            ExpressionContext context = (ExpressionContext)args[1];
            String qName = ((ExpressionValue)args[2]).getStringValue();
            ExpandedQName name = context.getExpandedName(qName);
            NamespaceName nsName = name.getNamespaceName();
            if (nsName.isEmpty()) {
                String systemProperty = System.getProperty(name.getLocalPart());
                if (systemProperty != null) {
                    result = new StringValue(systemProperty);
                }
            } else if (nsName.equals(Stylesheet.NAMESPACE)) {
                xsltSystemProperty.init();
                result = (ExpressionValue)xsltMap.get(name.getLocalPart());
            } else if (nsName.equals(Stylesheet.NXSL_NAMESPACE)) {
                xsltSystemProperty.init();
                result = (ExpressionValue)nxslMap.get(name.getLocalPart());
            }
            if (result == null) {
                result = new StringValue();
            }
            return result;
        }
        catch (ClassCastException e) {
            throw new XPathEvaluationException("pe11");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new XPathEvaluationException("pe9");
        }
    }

    public String toString() {
        return "system-property";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        Object object = gate;
        synchronized (object) {
            if (xsltMap == null) {
                xsltMap = new HashMap();
                xsltMap.put("version", new NumberValue(NumberValue.convertToNumber("1.0")));
                xsltMap.put("vendor", new StringValue("Novell, Inc."));
                xsltMap.put("vendor-url", new StringValue("http://www.novell.com"));
            }
            if (nxslMap == null) {
                nxslMap = new HashMap();
                nxslMap.put("version", new NumberValue(NumberValue.convertToNumber(Integer.toString(2) + "." + Integer.toString(1))));
                nxslMap.put("build", new NumberValue(NumberValue.convertToNumber(Integer.toString(0))));
            }
        }
    }

    private static FunctionSignature createSignature() {
        try {
            Class[] reqArgs = new Class[]{FunctionSignature.getContextArgTypes()[0], FunctionSignature.getContextArgTypes()[1], StringValue.getArgType()};
            return new FunctionSignature(new ExpandedQName("", "system-property"), Class.forName("com.novell.xml.xpath.ExpressionValue"), reqArgs);
        }
        catch (ClassNotFoundException e) {
            throw new Error(e.getLocalizedMessage());
        }
    }
}

