/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.functions;

import com.novell.util.URIResolver;
import com.novell.xml.dom.NodeImpl;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.Function;
import com.novell.xml.xpath.FunctionSignature;
import com.novell.xml.xpath.StringValue;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.process.Context;
import java.net.URL;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class xsltUnparsedEntityURI
extends Function {
    public xsltUnparsedEntityURI() {
        super(xsltUnparsedEntityURI.createSignature());
    }

    public ExpressionValue invoke(Object[] args) throws XPathEvaluationException {
        try {
            DocumentType docType;
            Node contextNode = (Node)args[0];
            Context context = (Context)args[1];
            String name = ((ExpressionValue)args[2]).getStringValue();
            Document doc = contextNode.getOwnerDocument();
            if (doc == null) {
                doc = (Document)contextNode;
            }
            if ((docType = doc.getDoctype()) != null) {
                NamedNodeMap map = docType.getEntities();
                int len = map.getLength();
                for (int i = 0; i < len; ++i) {
                    URL baseURL;
                    Node node = map.item(i);
                    if (!(node instanceof Entity)) continue;
                    Entity entity = (Entity)node;
                    String entityName = entity.getNodeName();
                    if (name == null || !name.equals(entityName)) continue;
                    String systemId = entity.getSystemId();
                    if (systemId == null) break;
                    systemId = entity instanceof NodeImpl ? URIResolver.resolveURI(systemId, ((NodeImpl)((Object)entity)).getBaseURI()) : URIResolver.resolveURI(systemId, (baseURL = context.getBaseURI(contextNode)) != null ? baseURL.toString() : null);
                    return new StringValue(systemId);
                }
            }
            return new StringValue();
        }
        catch (ClassCastException e) {
            throw new XPathEvaluationException("pe11");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new XPathEvaluationException("pe9");
        }
        catch (IllegalArgumentException e) {
            throw new XPathEvaluationException(this.toString() + ": " + e.getMessage());
        }
    }

    public String toString() {
        return "unparsed-entity-uri";
    }

    private static FunctionSignature createSignature() {
        Class[] reqArgs = new Class[]{FunctionSignature.getContextArgTypes()[0], FunctionSignature.getContextArgTypes()[1], StringValue.getArgType()};
        return new FunctionSignature(new ExpandedQName("", "unparsed-entity-uri"), StringValue.getArgType(), reqArgs);
    }
}

