/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.number;

import com.novell.xsl.number.NumberFormatter;

public class AlphabeticNumberFormatter
implements NumberFormatter {
    private final char[] digits;

    public AlphabeticNumberFormatter(String digits) {
        this.digits = digits.toCharArray();
    }

    public String format(int value) throws IllegalArgumentException {
        if (value <= 0) {
            throw new IllegalArgumentException("illegal value: " + value);
        }
        char[] buf = new char[99];
        int i = buf.length;
        int radix = this.digits.length;
        do {
            buf[--i] = this.digits[--value % radix];
        } while ((value /= radix) > 0);
        return new String(buf, i, buf.length - i);
    }
}

