/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.number;

import com.novell.xsl.number.NumberFormatter;
import com.novell.xsl.util.Util;

public class DecimalNumberFormatter
implements NumberFormatter {
    private final char firstDigit;
    private final int minDigits;

    public DecimalNumberFormatter(char firstDigit, int minDigits) {
        if (Character.digit(firstDigit, 10) != 0) {
            throw new IllegalArgumentException("illegal first digit: " + Util.unicodeEscape(firstDigit));
        }
        if (minDigits < 0) {
            throw new IllegalArgumentException("illegal minimum number of digits: " + minDigits);
        }
        this.firstDigit = firstDigit;
        this.minDigits = minDigits;
    }

    public String format(int value) throws IllegalArgumentException {
        char[] buf;
        if (value <= 0) {
            throw new IllegalArgumentException("illegal value: " + value);
        }
        String simpleStr = Integer.toString(value);
        int simpleLen = simpleStr.length();
        if (simpleLen >= this.minDigits && this.firstDigit == '0') {
            return simpleStr;
        }
        if (simpleLen >= this.minDigits) {
            buf = new char[simpleLen];
        } else {
            buf = new char[this.minDigits];
            for (int i = this.minDigits - simpleLen - 1; i >= 0; --i) {
                buf[i] = this.firstDigit;
            }
        }
        char[] simpleArray = simpleStr.toCharArray();
        int delta = this.firstDigit - 48;
        int i = buf.length;
        do {
            buf[--i] = (char)(simpleArray[--simpleLen] + delta);
        } while (simpleLen > 0);
        return new String(buf);
    }
}

