/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.number;

import com.novell.xsl.number.AlphabeticNumberFormatter;
import com.novell.xsl.number.DecimalNumberFormatter;
import com.novell.xsl.number.NumberFormatter;
import com.novell.xsl.number.RomanNumberFormatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class NumberFormatters {
    private static final HashMap numericMap = new HashMap();
    private static final HashMap langMap = new HashMap();
    private static final LanguageMap enMap = new LanguageMap();
    private static final NumberFormatter defaultFormatter = new DecimalNumberFormatter('0', 1);

    private NumberFormatters() {
    }

    public static void add(String formatToken, String lang, String letterValue, NumberFormatter formatter) throws IllegalArgumentException {
        boolean numeric = NumberFormatters.isDecimalFormatToken(formatToken);
        if (formatToken == null || formatToken.equals("") || formatToken.equals("A") || formatToken.equals("a") || formatToken.equals("I") || formatToken.equals("i") || numeric) {
            throw new IllegalArgumentException("illegal format token: " + formatToken);
        }
        LanguageMap lMap = NumberFormatters.createLanguageMap(lang);
        lMap.setFormatter(formatter, formatToken, letterValue == null || "alphabetic".equals(letterValue));
    }

    public static NumberFormatter get(String formatToken, String lang, String letterValue) {
        NumberFormatter formatter = null;
        boolean numeric = NumberFormatters.isDecimalFormatToken(formatToken);
        if (numeric) {
            formatter = (NumberFormatter)numericMap.get(formatToken);
            if (formatter == null) {
                int len = formatToken.length();
                char firstDigit = (char)(formatToken.charAt(len - 1) - '\u0001');
                formatter = new DecimalNumberFormatter(firstDigit, len);
                numericMap.put(formatToken, formatter);
            }
        } else if (formatToken.equals("A") || formatToken.equals("a") || formatToken.equals("I") || formatToken.equals("i")) {
            formatter = enMap.getFormatter(formatToken, true);
        } else {
            LanguageMap lMap = NumberFormatters.getLanguageMap(lang);
            if (lMap != null) {
                formatter = lMap.getFormatter(formatToken, letterValue == null || "alphabetic".equals(letterValue));
            }
        }
        if (formatter == null) {
            formatter = defaultFormatter;
        }
        return formatter;
    }

    private static boolean isDecimalFormatToken(String formatToken) {
        if (formatToken == null) {
            return false;
        }
        int len = formatToken.length();
        if (len == 0) {
            return false;
        }
        char lastChar = formatToken.charAt(len - 1);
        if (Character.digit(lastChar, 10) != 1) {
            return false;
        }
        for (int i = 0; i < len - 1; ++i) {
            if (formatToken.charAt(i) == lastChar - '\u0001') continue;
            return false;
        }
        return true;
    }

    private static LanguageMap createLanguageMap(String lang) {
        String upLang = lang.toUpperCase(Locale.US);
        LanguageMap map = (LanguageMap)langMap.get(upLang);
        if (map == null) {
            langMap.put(upLang, new LanguageMap());
        }
        return map;
    }

    private static LanguageMap getLanguageMap(String lang) {
        String upLang = lang.toUpperCase(Locale.US);
        LanguageMap map = (LanguageMap)langMap.get(upLang);
        if (map == null) {
            int index;
            while (map == null && (index = upLang.lastIndexOf(45)) > 0) {
                upLang = upLang.substring(0, index);
                map = (LanguageMap)langMap.get(upLang);
            }
        }
        return map;
    }

    static {
        numericMap.put("1", defaultFormatter);
        enMap.setFormatter(new AlphabeticNumberFormatter("ABCDEFGHIJKLMNOPQRSTUVWXYZ"), "A", true);
        enMap.setFormatter(new AlphabeticNumberFormatter("abcdefghijklmnopqrstuvwxyz"), "a", true);
        enMap.setFormatter(new RomanNumberFormatter(false), "I", true);
        enMap.setFormatter(new RomanNumberFormatter(true), "i", true);
        langMap.put("EN", enMap);
        langMap.put("EN-US", enMap);
    }

    private static class LanguageMap {
        private Map alphabeticFormatters = null;
        private Map traditionalFormatters = null;

        private LanguageMap() {
        }

        public NumberFormatter getFormatter(String formatToken, boolean isAlphabetic) {
            if (isAlphabetic) {
                if (this.alphabeticFormatters != null) {
                    return (NumberFormatter)this.alphabeticFormatters.get(formatToken);
                }
            } else if (this.traditionalFormatters != null) {
                return (NumberFormatter)this.traditionalFormatters.get(formatToken);
            }
            return null;
        }

        public void setFormatter(NumberFormatter formatter, String formatToken, boolean isAlphabetic) {
            if (isAlphabetic) {
                if (this.alphabeticFormatters == null) {
                    this.alphabeticFormatters = new HashMap();
                }
                this.alphabeticFormatters.put(formatToken, formatter);
            } else {
                if (this.traditionalFormatters == null) {
                    this.traditionalFormatters = new HashMap();
                }
                this.traditionalFormatters.put(formatToken, formatter);
            }
        }
    }
}

