/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.number;

import com.novell.xsl.number.NumberFormatter;

public class RomanNumberFormatter
implements NumberFormatter {
    private static final int[] TEN = new int[]{1000, 100, 10, 1};
    private static final int[] NINE = new int[]{900, 90, 9};
    private static final int[] FIVE = new int[]{500, 50, 5};
    private static final int[] FOUR = new int[]{400, 40, 4, 9999};
    private final char[] romanLetters;

    public RomanNumberFormatter(boolean useLowerCase) {
        this.romanLetters = useLowerCase ? new char[]{'m', 'd', 'c', 'l', 'x', 'v', 'i'} : new char[]{'M', 'D', 'C', 'L', 'X', 'V', 'I'};
    }

    public String format(int value) throws IllegalArgumentException {
        if (value <= 0) {
            throw new IllegalArgumentException("illegal value: " + value);
        }
        if (value > 3999) {
            return Integer.toString(value);
        }
        char[] buf = new char[15];
        int len = 0;
        int decimalIndex = 0;
        int romanIndex = 0;
        while (decimalIndex <= 3) {
            while (value >= TEN[decimalIndex]) {
                value -= TEN[decimalIndex];
                buf[len++] = this.romanLetters[romanIndex];
            }
            if (value >= FOUR[decimalIndex]) {
                if (value >= FIVE[decimalIndex]) {
                    if (value >= NINE[decimalIndex]) {
                        value -= NINE[decimalIndex];
                        buf[len++] = this.romanLetters[romanIndex + 2];
                        buf[len++] = this.romanLetters[romanIndex];
                    } else {
                        value -= FIVE[decimalIndex];
                        buf[len++] = this.romanLetters[romanIndex + 1];
                    }
                } else {
                    value -= FOUR[decimalIndex];
                    buf[len++] = this.romanLetters[romanIndex + 2];
                    buf[len++] = this.romanLetters[romanIndex + 1];
                }
            }
            ++decimalIndex;
            romanIndex += 2;
        }
        return new String(buf, 0, len);
    }
}

