/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl;

import com.novell.io.EncodingStreamWriter;
import com.novell.util.URIResolver;
import com.novell.xml.dom.DOMUtil;
import com.novell.xml.dom.DOMWriter;
import com.novell.xml.dom.DocumentFactory;
import com.novell.xml.dom.DocumentImpl;
import com.novell.xml.parser.SAXParserImpl;
import com.novell.xml.parser.XMLParser;
import com.novell.xml.sax.SAXWriter;
import com.novell.xml.util.XMLUtil;
import com.novell.xml.util.XmlWriter;
import com.novell.xsl.DefaultErrorHandler;
import com.novell.xsl.DefaultMessageHandler;
import com.novell.xsl.SAXtoDOMStrip;
import com.novell.xsl.Stylesheet;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.extensions.ECMAScriptFunction;
import com.novell.xsl.result.DOMResultHandler;
import com.novell.xsl.result.SAXResultHandler;
import com.novell.xsl.result.SerializerOptions;
import com.novell.xsl.util.Timer;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class nxsl {
    private static final int TIMES_SOURCE_PARSE = 0;
    private static final int TIMES_XSL_PARSE = 1;
    private static final int TIMES_COMPILE = 2;
    private static final int TIMES_PROCESS = 3;
    private static final int TIMES_TOTAL = 4;
    private static final int TIMES_ARRAY_SIZE = 5;
    private static final int USAGE_MESSAGE_COUNT = 19;
    private static final String STYLESHEET_REQUIRED = "e1";
    private static final String PARSE_ERRORS = "e2";
    private static final String TOO_MANY_FILENAMES = "e3";
    private static final String FILENAME_REQUIRED = "e4";
    private static final String VERSION_MSG = "e5";
    private static final String UNRECOGNIZED_OPTION = "e6";
    private static final String SOURCE_DOC_REQUIRED = "e7";
    private static final String DOM2_NAMESPACES = "e9";
    private static final String URI_REQUIRED = "e10";
    private static final String TIMER_HEADER = "tm1";
    private static final String TIMER_PARSE = "tm2";
    private static final String TIMER_COMPILE = "tm3";
    private static final String TIMER_PROCESS = "tm4";
    private static final String TIMER_TOTAL = "tm5";
    boolean dumpStylesheet = false;
    int traceLevel = 0;
    boolean suppressErrors = false;
    boolean redirectErrors = false;
    boolean suppressWarnings = false;
    boolean printTimes = false;
    boolean forceDOM = false;
    boolean forceSAX = false;
    String xmlFilename = null;
    String xslFilename = null;
    String resultFilename = null;
    List stylesheetParms = null;
    long[] times = null;
    Timer timer = null;
    XMLParser xmlParser;
    Stylesheet stylesheet = null;
    boolean alreadyStripped = false;
    boolean waitForDebugger = false;
    boolean brokenMode = false;
    List stylesheetScripts = null;
    Map stylesheetProperties = null;

    public static void main(String[] args) {
        nxsl instance = new nxsl();
        instance.instanceMain(args);
    }

    private void instanceMain(String[] args) {
        this.xmlParser = new SAXParserImpl();
        try {
            PrintWriter out;
            OutputStream outStream;
            this.parseCommandLine(args);
            if (this.redirectErrors) {
                System.setErr(System.out);
            }
            if (this.waitForDebugger) {
                System.out.println("Press enter to continue");
                try {
                    System.in.read();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.printTimes) {
                this.times = new long[5];
                this.timer = new Timer();
            }
            if (this.stylesheetScripts != null) {
                this.stylesheetProperties = new TreeMap();
                this.stylesheetProperties.put("com.novell.xsl.extensions.ECMAScriptFunction.scope", ECMAScriptFunction.evaluateCommandLineScripts(this.stylesheetScripts, null));
            }
            if (this.xslFilename != null) {
                this.constructStylesheet(this.xslFilename);
            }
            Document xmlDoc = null;
            if (!this.forceSAX) {
                xmlDoc = this.constructSource(this.xmlFilename);
            }
            if (this.xslFilename == null && xmlDoc != null) {
                this.stylesheet = new Stylesheet(this.stylesheetProperties);
                this.stylesheet.setBrokenMode(this.brokenMode);
                this.stylesheet.loadFromSource(xmlDoc, this.xmlFilename);
                if (!this.stylesheet.isLoaded()) {
                    nxsl.commandLineError(STYLESHEET_REQUIRED, null);
                }
            }
            if (this.traceLevel != 0) {
                Trace.setPrintWriter(new PrintWriter(System.err, true));
                Trace.setTraceLevel(this.traceLevel);
            }
            if (this.resultFilename == null) {
                outStream = System.out;
                out = new PrintWriter(outStream);
            } else {
                outStream = new FileOutputStream(this.resultFilename);
                out = new PrintWriter(new BufferedOutputStream(outStream));
            }
            if (this.dumpStylesheet) {
                this.stylesheet.dump(out);
            } else {
                Writer writer;
                String[] encoding;
                SerializerOptions options;
                if (this.stylesheetParms != null) {
                    Iterator it = this.stylesheetParms.iterator();
                    while (it.hasNext()) {
                        StylesheetParm parm = (StylesheetParm)it.next();
                        this.stylesheet.setParameter(parm.getQName(), parm.getExpression());
                    }
                }
                if (this.forceDOM) {
                    this.stylesheet.setResultHandler(new DOMResultHandler(DocumentFactory.newDocument()));
                } else if (this.forceSAX) {
                    SAXResultHandler resultHandler = new SAXResultHandler(this.stylesheet);
                    InputSource inputSource = new InputSource(this.xmlFilename);
                    options = this.stylesheet.getSerializerOptions();
                    encoding = new String[1];
                    writer = this.setupOutputWriter(encoding, options, outStream);
                    SAXWriter serializer = new SAXWriter(resultHandler, inputSource, writer);
                    this.setupXmlWriter(serializer, encoding[0], options);
                    resultHandler.setDocumentHandler(serializer);
                    serializer.write();
                    serializer.flush();
                } else {
                    this.stylesheet.setSerializerStream(outStream);
                }
                if (!this.forceSAX) {
                    this.stylesheet.process(xmlDoc, new URL(this.xmlFilename), this.alreadyStripped);
                }
                if (this.printTimes) {
                    this.times[3] = this.timer.getLapTime();
                }
                if (this.forceDOM) {
                    Document result = ((DOMResultHandler)this.stylesheet.getResultHandler()).getDocument();
                    if (!this.suppressErrors && !DOMUtil.checkNamespacesAgree(result)) {
                        nxsl.showError(DOM2_NAMESPACES);
                    }
                    options = this.stylesheet.getSerializerOptions();
                    encoding = new String[1];
                    writer = this.setupOutputWriter(encoding, options, outStream);
                    DOMWriter serializer = new DOMWriter(result, writer);
                    this.setupXmlWriter(serializer, encoding[0], options);
                    serializer.write();
                    serializer.flush();
                }
                if (this.printTimes) {
                    this.times[4] = this.timer.getTotalTime();
                    nxsl.showMessage(TIMER_HEADER, null);
                    nxsl.showMessage(TIMER_PARSE, new String[]{this.timer.millisToString(this.times[0]), this.xmlFilename});
                    nxsl.showMessage(TIMER_PARSE, new String[]{this.timer.millisToString(this.times[1]), this.xslFilename});
                    nxsl.showMessage(TIMER_COMPILE, new String[]{this.timer.millisToString(this.times[2])});
                    nxsl.showMessage(TIMER_PROCESS, new String[]{this.timer.millisToString(this.times[3])});
                    nxsl.showMessage(TIMER_TOTAL, new String[]{this.timer.millisToString(this.times[4])});
                }
            }
            out.flush();
        }
        catch (IOException e) {
            System.out.println(e);
        }
        catch (XSLException e) {
            if (e.isError()) {
                System.out.println(e);
            }
            System.out.println(e.getMessage());
        }
    }

    private Document constructSource(String xmlFilename) throws IOException {
        if (this.stylesheet != null) {
            ((SAXParserImpl)this.xmlParser).setConverter(new SAXtoDOMStrip(DocumentImpl.newDocument(), this.stylesheet.getStripList()));
            this.alreadyStripped = true;
        }
        Document xmlDoc = this.xmlParser.parse(xmlFilename);
        if (this.printTimes) {
            this.times[0] = this.timer.getLapTime();
        }
        if (this.xmlParser.anyErrors()) {
            nxsl.showError(PARSE_ERRORS, xmlFilename);
            this.xmlParser.reportErrorMsgs(System.err);
            System.exit(1);
        }
        if (this.stylesheet != null) {
            ((SAXParserImpl)this.xmlParser).setConverter(null);
        }
        return xmlDoc;
    }

    private void constructStylesheet(String xslFilename) throws XSLException, IOException {
        Document xslDoc = this.xmlParser.parse(xslFilename);
        if (this.printTimes) {
            this.times[1] = this.timer.getLapTime();
        }
        if (this.xmlParser.anyErrors()) {
            nxsl.showError(PARSE_ERRORS, xslFilename);
            this.xmlParser.reportErrorMsgs(System.out);
            System.exit(1);
        }
        DefaultErrorHandler errorHandler = new DefaultErrorHandler();
        errorHandler.setLogErrors(!this.suppressErrors);
        errorHandler.setLogWarnings(!this.suppressWarnings);
        DefaultMessageHandler messageHandler = new DefaultMessageHandler();
        this.stylesheet = new Stylesheet(this.stylesheetProperties);
        this.stylesheet.setBrokenMode(this.brokenMode);
        this.stylesheet.setErrorHandler(errorHandler);
        this.stylesheet.setMessageHandler(messageHandler);
        if (xslDoc != null) {
            this.stylesheet.setBaseURI(xslFilename);
            this.stylesheet.load(xslDoc);
        }
        if (this.printTimes) {
            this.times[2] = this.timer.getLapTime();
        }
    }

    private Writer setupOutputWriter(String[] actualEncoding, SerializerOptions options, OutputStream outStream) throws UnsupportedEncodingException {
        Writer writer;
        try {
            if (options != null && options.getEncoding() != null && options.getEncoding().length() > 0) {
                try {
                    writer = new EncodingStreamWriter(outStream, options.getEncoding());
                    actualEncoding[0] = ((EncodingStreamWriter)writer).getEncoding();
                }
                catch (UnsupportedEncodingException e) {
                    writer = new OutputStreamWriter(outStream, options.getEncoding());
                    actualEncoding[0] = ((OutputStreamWriter)writer).getEncoding();
                }
            } else {
                writer = new EncodingStreamWriter(outStream, "UTF-8");
                actualEncoding[0] = ((EncodingStreamWriter)writer).getEncoding();
            }
        }
        catch (UnsupportedEncodingException e) {
            writer = new EncodingStreamWriter(outStream, "UTF-8");
            actualEncoding[0] = ((EncodingStreamWriter)writer).getEncoding();
        }
        return writer;
    }

    private void setupXmlWriter(XmlWriter serializer, String actualEncoding, SerializerOptions options) {
        serializer.setEncoding(actualEncoding);
        if (options != null) {
            serializer.setWriteDeclaration(options.getDeclaration());
            serializer.setIndent(options.getIndent());
            serializer.setStandalone(options.getStandalone());
            serializer.setDoctypeSystem(options.getDoctypeSystem());
            serializer.setDoctypePublic(options.getDoctypePublic());
            serializer.setCdataSectionElements(options.getCdataSectionElements());
        }
    }

    private void parseCommandLine(String[] args) throws MalformedURLException {
        int[] argIndex = null;
        String base = XMLUtil.filenameToURL(".").toString();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) != '-') {
                if (this.xmlFilename == null) {
                    this.xmlFilename = args[i];
                    continue;
                }
                if (this.xslFilename == null) {
                    this.xslFilename = args[i];
                    continue;
                }
                nxsl.commandLineError(TOO_MANY_FILENAMES, null);
                continue;
            }
            if (args[i].equals("-d")) {
                this.dumpStylesheet = true;
                continue;
            }
            if (args[i].equals("-d1")) {
                this.traceLevel = 1;
                continue;
            }
            if (args[i].equals("-d2")) {
                this.traceLevel = 2;
                continue;
            }
            if (args[i].equals("-d3")) {
                this.traceLevel = 3;
                continue;
            }
            if (args[i].equals("-d4")) {
                this.traceLevel = 4;
                continue;
            }
            if (args[i].equals("-debug")) {
                this.waitForDebugger = true;
                continue;
            }
            if (args[i].equals("-e")) {
                this.suppressErrors = true;
                continue;
            }
            if (args[i].equals("-e1")) {
                this.redirectErrors = true;
                continue;
            }
            if (args[i].equals("-es")) {
                if (i < args.length) {
                    if (this.stylesheetScripts == null) {
                        this.stylesheetScripts = new ArrayList();
                        argIndex = new int[1];
                    }
                    this.stylesheetScripts.add(URIResolver.resolveURI(args[++i], base));
                    continue;
                }
                nxsl.commandLineError(URI_REQUIRED, new Object[]{"-es"});
                continue;
            }
            if (args[i].equals("-o")) {
                if (i < args.length) {
                    this.resultFilename = args[++i];
                    continue;
                }
                nxsl.commandLineError(FILENAME_REQUIRED, null);
                continue;
            }
            if (args[i].equals("-p")) {
                if (this.stylesheetParms == null) {
                    this.stylesheetParms = new ArrayList();
                    argIndex = new int[]{i};
                }
                try {
                    this.stylesheetParms.add(nxsl.parseStylesheetParm(args, argIndex));
                }
                catch (XSLException e) {
                    nxsl.commandLineError(e.getMessage(), null);
                }
                i = argIndex[0];
                continue;
            }
            if (args[i].equals("-r")) {
                if (i + 1 >= args.length) {
                    nxsl.commandLineError(null, null);
                }
                if (args[++i].equals("DOM")) {
                    this.forceDOM = true;
                    continue;
                }
                if (!args[i].equals("SAX")) continue;
                this.forceSAX = true;
                continue;
            }
            if (args[i].equals("-t")) {
                this.printTimes = true;
                continue;
            }
            if (args[i].equals("-v")) {
                nxsl.showMessage(VERSION_MSG, new String[]{"Novell XSLT Processor", "2.01.00"});
                System.exit(0);
                continue;
            }
            if (args[i].equals("-w")) {
                this.suppressWarnings = true;
                continue;
            }
            if (args[i].equals("-usebroken")) {
                this.brokenMode = true;
                continue;
            }
            nxsl.commandLineError(UNRECOGNIZED_OPTION, new String[]{args[i]});
        }
        if (args.length == 0) {
            nxsl.commandLineError(null, null);
        } else if (this.xmlFilename == null) {
            nxsl.commandLineError(SOURCE_DOC_REQUIRED, null);
        }
        this.xmlFilename = URIResolver.resolveURI(this.xmlFilename, base);
        if (this.xslFilename != null) {
            this.xslFilename = URIResolver.resolveURI(this.xslFilename, base);
        }
    }

    private static StylesheetParm parseStylesheetParm(String[] args, int[] argIndex) throws XSLException {
        try {
            int i = argIndex[0];
            int n = ++i;
            String name = args[n];
            String arg = args[++i];
            argIndex[0] = i;
            return new StylesheetParm(name, arg);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new XSLException("Bad -p syntax");
        }
    }

    private static void commandLineError(String key, Object[] parms) {
        if (key != null) {
            System.err.println(nxsl.constructMessage(key, parms));
        }
        String usageBase = "u";
        for (int i = 1; i <= 19; ++i) {
            String usageMsg = usageBase + i;
            System.err.println(nxsl.constructMessage(usageMsg, null));
        }
        System.exit(1);
    }

    public static void showError(String key) {
        System.err.println(nxsl.constructMessage(key, null));
    }

    public static void showError(String key, String parm0) {
        System.err.println(nxsl.constructMessage(key, new String[]{parm0}));
    }

    public static void showMessage(String key, Object[] parms) {
        System.out.println(nxsl.constructMessage(key, parms));
    }

    public static String constructMessage(String key, Object[] parms) {
        ResourceBundle bundle = ResourceBundle.getBundle("com.novell.xsl.nxsl_messages");
        try {
            key = bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
        return parms == null ? key : MessageFormat.format(key, parms);
    }

    private static class StylesheetParm {
        private String qName;
        private String expString;

        public StylesheetParm(String qName, String expString) {
            this.qName = qName;
            this.expString = expString;
        }

        public String getQName() {
            return this.qName;
        }

        public String getExpression() {
            return this.expString;
        }
    }
}

