/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.parser;

import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.Parser;
import com.novell.xml.xpath.StringValue;
import com.novell.xml.xpath.Token;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathParserException;
import com.novell.xml.xpath.XPathResetRegistrar;
import com.novell.xml.xpath.XPathUtil;
import com.novell.xsl.ErrorHandler;
import com.novell.xsl.parser.AVTLiteralToken;
import com.novell.xsl.parser.AVTScanner;
import com.novell.xsl.parser.AVTSeparatorToken;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.w3c.dom.Node;

public class AVT
implements Expression {
    private Expression[] operands;

    public static Expression parse(String source, Parser xpathParser, ErrorHandler errorHandler) throws XPathParserException {
        AVTScanner scanner = new AVTScanner(source);
        Token[] tokens = scanner.scan();
        if (scanner.getScanException() != null) {
            errorHandler.warning(scanner.getScanException().getMessage());
        }
        if (tokens.length == 1 && tokens[0] instanceof AVTLiteralToken) {
            return new StringValue(((AVTLiteralToken)tokens[0]).getValue());
        }
        ArrayList<Expression> expressions = new ArrayList<Expression>(8);
        ArrayList<Token> expTokens = new ArrayList<Token>(32);
        for (int i = 0; i < tokens.length; ++i) {
            if (tokens[i] instanceof AVTLiteralToken || tokens[i] instanceof AVTSeparatorToken) {
                if (expTokens.size() > 0) {
                    Token[] tempTokens = new Token[expTokens.size()];
                    expTokens.toArray(tempTokens);
                    expTokens.clear();
                    expressions.add(xpathParser.parse(tempTokens));
                }
                if (!(tokens[i] instanceof AVTLiteralToken)) continue;
                expressions.add(new StringValue(((AVTLiteralToken)tokens[i]).getValue()));
                continue;
            }
            expTokens.add(tokens[i]);
        }
        if (expTokens.size() > 0) {
            tokens = new Token[expTokens.size()];
            expTokens.toArray(tokens);
            expressions.add(xpathParser.parse(tokens));
        }
        Expression[] result = new Expression[expressions.size()];
        expressions.toArray(result);
        return new AVT(result);
    }

    protected AVT(Expression[] operands) {
        this.operands = operands;
    }

    public Expression[] getOperands() {
        return this.operands;
    }

    public String toString() {
        String result = new String();
        for (int i = 0; i < this.operands.length; ++i) {
            result = !(this.operands[i] instanceof StringValue) ? result + "{" + this.operands[i].toString() + "}" : result + this.operands[i].toString();
        }
        return result;
    }

    public ExpressionValue evaluate(Node contextNode, ExpressionContext context) throws XPathEvaluationException {
        StringBuffer sb = new StringBuffer(128);
        for (int i = 0; i < this.operands.length; ++i) {
            sb.append(context.evaluate(contextNode, this.operands[i]).getStringValue());
        }
        return new StringValue(sb.toString());
    }

    public boolean isConstant() {
        for (int i = 0; i < this.operands.length; ++i) {
            if (this.operands[i].isConstant()) continue;
            return false;
        }
        return true;
    }

    public Class getResultType() {
        return StringValue.getArgType();
    }

    public void registerForReset(XPathResetRegistrar registrar) {
        for (int i = 0; i < this.operands.length; ++i) {
            this.operands[i].registerForReset(registrar);
        }
    }

    public void dump(PrintWriter writer, int indent) {
        XPathUtil.dump(this, writer, indent);
    }
}

