/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.parser;

import com.novell.xml.xpath.Scanner;
import com.novell.xml.xpath.XPathParserException;
import com.novell.xsl.parser.AVTLiteralToken;
import com.novell.xsl.parser.AVTSeparatorToken;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

class AVTScanner
extends Scanner {
    private boolean inExpression = false;
    private StringBuffer buffer = new StringBuffer(128);
    private final boolean[] stateStack = new boolean[8];
    private int stackTop;
    private XPathParserException scanException = null;

    AVTScanner(String source) {
        super(source);
    }

    public XPathParserException getScanException() {
        return this.scanException;
    }

    protected char prescanChar(char scanChar) {
        if (this.inExpression) {
            if (scanChar == '}') {
                this.inExpression = false;
                return '\ufffd';
            }
            return scanChar;
        }
        if (scanChar == '{') {
            this.pushPos();
            if (this.getNextChar() == '{') {
                this.tossPos();
                this.buffer.append(scanChar);
            } else {
                this.popPos();
                if (this.buffer.length() > 0) {
                    this.appendToken(new AVTLiteralToken(this.buffer.toString()));
                    this.buffer.setLength(0);
                } else if (this.lastToken() != null && this.lastToken().getType() != 18) {
                    this.appendToken(new AVTSeparatorToken());
                }
                this.inExpression = true;
            }
        } else if (scanChar == '}') {
            this.pushPos();
            if (this.getNextChar() == '}') {
                this.tossPos();
            } else {
                this.popPos();
                ResourceBundle bundle = ResourceBundle.getBundle("com.novell.xsl.parser.StylesheetParser_errors");
                String msg = "ae1";
                try {
                    msg = bundle.getString(msg);
                }
                catch (MissingResourceException e) {
                    // empty catch block
                }
                this.scanException = new XPathParserException(msg);
            }
            this.buffer.append(scanChar);
        } else {
            this.buffer.append(scanChar);
        }
        return '\u0000';
    }

    protected void done() {
        if (this.buffer.length() > 0) {
            this.appendToken(new AVTLiteralToken(this.buffer.toString()));
        }
    }

    protected void reset() {
        super.reset();
        this.inExpression = false;
    }

    protected void pushPos() {
        super.pushPos();
        this.stateStack[this.stackTop++] = this.inExpression;
    }

    protected void tossPos() {
        super.tossPos();
        --this.stackTop;
    }

    protected void popPos() {
        super.popPos();
        this.inExpression = this.stateStack[--this.stackTop];
    }
}

