/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.parser;

import com.novell.xml.dom.DOMUtil;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.Expression;
import com.novell.xsl.Stylesheet;
import com.novell.xsl.parser.AttrDef;
import com.novell.xsl.parser.StylesheetParser;
import com.novell.xsl.parser.WithParamParser;
import com.novell.xsl.parser.XSLTParserException;
import com.novell.xsl.process.ApplyTemplatesTemplate;
import com.novell.xsl.process.Mode;
import com.novell.xsl.process.SortCriteria;
import com.novell.xsl.process.SortKey;
import com.novell.xsl.process.Template;
import com.novell.xsl.util.Util;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ApplyTemplatesParser {
    private static AttrDef[] applyTemplatesAttr = new AttrDef[]{new AttrDef("mode", 0, Mode.DEFAULT_MODE, 4), new AttrDef("select", 0, null, 8)};

    public static Template parse(StylesheetParser stylesheetParser, Element element) throws XSLTParserException {
        Object[] attr = AttrDef.parseAttributes(stylesheetParser, element, applyTemplatesAttr);
        Mode mode = (Mode)attr[0];
        Expression select = (Expression)attr[1];
        ArrayList<SortKey> sortElements = new ArrayList<SortKey>();
        ArrayList<Template> paramElements = new ArrayList<Template>();
        block5: for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getNodeType()) {
                case 1: {
                    ExpandedQName elementName = DOMUtil.getExpandedName(node);
                    if (elementName.namespaceNameEquals(Stylesheet.NAMESPACE)) {
                        if (elementName.localPartEquals("sort")) {
                            stylesheetParser.pushNSContext(element);
                            sortElements.add(stylesheetParser.parseSortElement((Element)node));
                            stylesheetParser.popNSContext();
                            continue block5;
                        }
                        if (elementName.localPartEquals("with-param")) {
                            Template template = WithParamParser.parse(stylesheetParser, (Element)node);
                            if (template == null) continue block5;
                            paramElements.add(template);
                            continue block5;
                        }
                    }
                    stylesheetParser.reportError(element, node, "spe4");
                    continue block5;
                }
                case 7: 
                case 8: {
                    continue block5;
                }
                case 3: 
                case 4: {
                    if (Util.stripWhitespaceNode(node)) continue block5;
                    stylesheetParser.reportError(node, "spe4");
                    continue block5;
                }
                default: {
                    stylesheetParser.reportError(node, "spe4");
                }
            }
        }
        SortCriteria sortCriteria = null;
        if (sortElements.size() > 0) {
            SortKey[] sortKeys = new SortKey[sortElements.size()];
            sortElements.toArray(sortKeys);
            sortCriteria = new SortCriteria(sortKeys, element);
        }
        Template[] templates = null;
        templates = new Template[paramElements.size()];
        paramElements.toArray(templates);
        return new ApplyTemplatesTemplate(select, mode, sortCriteria, templates, element);
    }
}

