/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.parser;

import com.novell.xml.dom.DOMUtil;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.util.XMLUtil;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.Token;
import com.novell.xml.xpath.VariableReference;
import com.novell.xml.xpath.XPathParserException;
import com.novell.xsl.Stylesheet;
import com.novell.xsl.debug.Assert;
import com.novell.xsl.parser.AVT;
import com.novell.xsl.parser.StylesheetParser;
import com.novell.xsl.parser.XSLTParserException;
import com.novell.xsl.process.Mode;
import com.novell.xsl.process.Priority;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AttrDef {
    public static final int OPTIONAL = 0;
    public static final int REQUIRED = 1;
    public static final int AVT_EXPR = 0;
    public static final int ENUM = 1;
    public static final int TOP_PATTERN = 2;
    public static final int PATTERN = 3;
    public static final int MODE = 4;
    public static final int NAME = 5;
    public static final int QNAME = 6;
    public static final int PRIORITY = 7;
    public static final int SELECT_EXPR = 8;
    public static final int STRING = 9;
    public static final int TOP_EXPR = 10;
    public static final int EXPR = 11;
    public static final int CHAR = 12;
    private static final Integer[] INTEGERS = new Integer[]{new Integer(0), new Integer(1), new Integer(2)};
    private String name;
    private int optOrReq;
    private Object defaultValue;
    private int type;
    private String[] legalValues;

    public AttrDef(String name, int optOrReq, Object defaultValue, int type) {
        this.name = name;
        this.optOrReq = optOrReq;
        this.defaultValue = defaultValue;
        this.type = type;
    }

    public AttrDef(String name, int optOrReq, int defaultValue, String[] legalValues) {
        this.name = name;
        this.optOrReq = optOrReq;
        this.type = 1;
        this.defaultValue = defaultValue != -1 ? INTEGERS[defaultValue] : null;
        this.legalValues = legalValues;
        Assert.assertCondition(legalValues.length <= INTEGERS.length, "INTEGERS[] needs to be bigger");
    }

    public boolean isRequired() {
        return this.optOrReq == 1;
    }

    public static Object[] parseAttributes(StylesheetParser stylesheetParser, Element element, AttrDef[] desc) throws XSLTParserException {
        int i;
        Object[] attr = new Object[desc.length];
        NamedNodeMap attributes = element.getAttributes();
        for (i = 0; i < attributes.getLength(); ++i) {
            int j;
            NamespaceName ns;
            Node attribute = attributes.item(i);
            String name = attribute.getNodeName();
            if (name.startsWith("xmlns") || (ns = DOMUtil.getNamespaceName(attribute)) != null && !ns.isEmpty() && (!ns.equals(Stylesheet.NAMESPACE) || ns.equals(NamespaceName.XML_NAMESPACE))) continue;
            for (j = 0; j < desc.length; ++j) {
                if (!name.equals(desc[j].name)) continue;
                attr[j] = attribute.getNodeValue();
                break;
            }
            if (j < desc.length || stylesheetParser.isForwardsCompatibleMode()) continue;
            stylesheetParser.reportError(attribute, "spe6", attribute.getNodeName());
        }
        block28: for (i = 0; i < attr.length; ++i) {
            String value = (String)attr[i];
            attr[i] = desc[i].defaultValue;
            if (value == null) {
                if (desc[i].optOrReq != 1) continue;
                stylesheetParser.reportError((Node)element, "spe5", desc[i].name);
                continue;
            }
            switch (desc[i].type) {
                case 0: {
                    try {
                        attr[i] = AVT.parse(value, stylesheetParser.getXPathParser(), stylesheetParser.getStylesheet().getErrorHandler());
                        ((Expression)attr[i]).registerForReset(stylesheetParser.getStylesheet());
                    }
                    catch (XPathParserException e) {
                        attr[i] = stylesheetParser.reportAttributeExpressionError(element, desc[i].name, e);
                    }
                    continue block28;
                }
                case 12: {
                    if (value.length() != 1) {
                        stylesheetParser.reportInvalidAttributeValue(element, desc[i].name, desc[i].isRequired(), XMLUtil.quote(value));
                        continue block28;
                    }
                    attr[i] = new Character(value.charAt(0));
                    continue block28;
                }
                case 1: {
                    int j;
                    for (j = 0; j < desc[i].legalValues.length; ++j) {
                        if (!value.equals(desc[i].legalValues[j])) continue;
                        attr[i] = INTEGERS[j];
                        break;
                    }
                    if (j < desc[i].legalValues.length) continue block28;
                    stylesheetParser.reportInvalidAttributeValue(element, desc[i].name, desc[i].isRequired(), XMLUtil.quote(value));
                    continue block28;
                }
                case 10: {
                    try {
                        stylesheetParser.getXPathParser().tokenize(value);
                        Token[] tokens = stylesheetParser.getXPathParser().getTokens();
                        for (int j = 0; j < tokens.length; ++j) {
                            if (tokens[j].getType() != 17) continue;
                            throw new XPathParserException(XSLTParserException.constructMessage("spe21", null));
                        }
                        attr[i] = stylesheetParser.getXPathParser().parse(tokens);
                        ((Expression)attr[i]).registerForReset(stylesheetParser.getStylesheet());
                    }
                    catch (XPathParserException e) {
                        attr[i] = stylesheetParser.reportAttributeExpressionError(element, desc[i].name, e);
                    }
                    continue block28;
                }
                case 11: {
                    try {
                        attr[i] = stylesheetParser.getXPathParser().parse(value);
                        ((Expression)attr[i]).registerForReset(stylesheetParser.getStylesheet());
                    }
                    catch (XPathParserException e) {
                        attr[i] = stylesheetParser.reportAttributeExpressionError(element, desc[i].name, e);
                    }
                    continue block28;
                }
                case 2: 
                case 3: {
                    try {
                        attr[i] = stylesheetParser.getPatternParser().parsePattern(value, desc[i].type == 2);
                    }
                    catch (XPathParserException e) {
                        attr[i] = stylesheetParser.reportAttributeExpressionError(element, desc[i].name, e);
                    }
                    continue block28;
                }
                case 4: {
                    if (XMLUtil.isQName(value)) {
                        ExpandedQName name = stylesheetParser.getExpandedName(value);
                        attr[i] = Mode.create(name);
                        continue block28;
                    }
                    stylesheetParser.reportInvalidAttributeValue(element, desc[i].name, desc[i].isRequired(), XMLUtil.quote(value));
                    continue block28;
                }
                case 5: {
                    if (XMLUtil.isXMLName(value)) {
                        attr[i] = value;
                    } else {
                        stylesheetParser.reportInvalidAttributeValue(element, desc[i].name, desc[i].isRequired(), XMLUtil.quote(value));
                    }
                }
                case 6: {
                    if (XMLUtil.isQName(value)) {
                        attr[i] = stylesheetParser.getExpandedName(value);
                        continue block28;
                    }
                    stylesheetParser.reportInvalidAttributeValue(element, desc[i].name, desc[i].isRequired(), XMLUtil.quote(value));
                    continue block28;
                }
                case 7: {
                    try {
                        attr[i] = Priority.create(value);
                    }
                    catch (NumberFormatException e) {
                        stylesheetParser.reportInvalidAttributeValue(element, desc[i].name, desc[i].isRequired(), XMLUtil.quote(value));
                    }
                    continue block28;
                }
                case 8: {
                    try {
                        attr[i] = stylesheetParser.getXPathParser().parse(value);
                        ((Expression)attr[i]).registerForReset(stylesheetParser.getStylesheet());
                        if (((Expression)attr[i]).getResultType() == NodeSet.getArgType() || attr[i] instanceof VariableReference) continue block28;
                        stylesheetParser.reportError((Node)element, "spe16", desc[i].name);
                    }
                    catch (XPathParserException e) {
                        attr[i] = stylesheetParser.reportAttributeExpressionError(element, desc[i].name, e);
                    }
                    continue block28;
                }
                case 9: {
                    attr[i] = value;
                    continue block28;
                }
                default: {
                    stylesheetParser.reportError(element, "internal error: unknown attribute type");
                }
            }
        }
        return attr;
    }
}

