/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.parser;

import com.novell.xml.dom.DOMUtil;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.XMLUtil;
import com.novell.xsl.Stylesheet;
import com.novell.xsl.XSLException;
import com.novell.xsl.parser.AttrDef;
import com.novell.xsl.parser.AttributeParser;
import com.novell.xsl.parser.StylesheetParser;
import com.novell.xsl.parser.XSLTParserException;
import com.novell.xsl.process.AttributeSet;
import com.novell.xsl.process.Template;
import java.util.ArrayList;
import java.util.Collection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AttributeSetParser {
    private static AttrDef[] attributeSetAttr = new AttrDef[]{new AttrDef("name", 1, null, 6), new AttrDef("use-attribute-sets", 0, null, 9)};

    public static void parse(StylesheetParser stylesheetParser, Element element) throws XSLTParserException {
        Object[] attr = AttrDef.parseAttributes(stylesheetParser, element, attributeSetAttr);
        if (attr[0] == null) {
            return;
        }
        ExpandedQName name = (ExpandedQName)attr[0];
        Collection attributeSets = null;
        if (attr[1] != null) {
            attributeSets = stylesheetParser.parseQNames(element.getAttributeNode("use-attribute-sets"), (String)attr[1]);
        }
        ArrayList<Template> attributeList = new ArrayList<Template>();
        ExpandedQName attributeName = new ExpandedQName(Stylesheet.NAMESPACE, "attribute");
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            short nodeType = child.getNodeType();
            if (nodeType == 1) {
                ExpandedQName childName = DOMUtil.getExpandedName(child);
                if (attributeName.equals(childName)) {
                    stylesheetParser.pushNSContext(child);
                    Template attributeTemplate = AttributeParser.parse(stylesheetParser, (Element)child);
                    stylesheetParser.popNSContext();
                    attributeList.add(attributeTemplate);
                    continue;
                }
                stylesheetParser.reportError(element, child, "spe4");
                continue;
            }
            if (nodeType != 3 && nodeType != 4 || XMLUtil.isXMLWhitespace(child.getNodeValue())) continue;
            stylesheetParser.reportError(child, "spe4");
        }
        Template[] attributes = new Template[attributeList.size()];
        attributeList.toArray(attributes);
        try {
            stylesheetParser.getStylesheet().setAttributeSet(new AttributeSet(name, attributeSets, attributes, stylesheetParser.getImportPrecedence(), element));
        }
        catch (XSLException e) {
            stylesheetParser.reportError(element, e.getMessage());
        }
    }
}

