/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.parser;

import com.novell.xml.dom.DOMUtil;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.XMLUtil;
import com.novell.xsl.Stylesheet;
import com.novell.xsl.parser.AttrDef;
import com.novell.xsl.parser.OtherwiseParser;
import com.novell.xsl.parser.StylesheetParser;
import com.novell.xsl.parser.WhenParser;
import com.novell.xsl.parser.XSLTParserException;
import com.novell.xsl.process.ChooseTemplate;
import com.novell.xsl.process.OtherwiseTemplate;
import com.novell.xsl.process.Template;
import com.novell.xsl.process.WhenTemplate;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ChooseParser {
    private static AttrDef[] chooseAttr = new AttrDef[0];

    public static Template parse(StylesheetParser stylesheetParser, Element element) throws XSLTParserException {
        AttrDef.parseAttributes(stylesheetParser, element, chooseAttr);
        ArrayList<Template> whenList = new ArrayList<Template>();
        OtherwiseTemplate otherwiseTemplate = null;
        block5: for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getNodeType()) {
                case 1: {
                    Element childElement = (Element)child;
                    ExpandedQName elementName = DOMUtil.getExpandedName(childElement);
                    if (elementName.namespaceNameEquals(Stylesheet.NAMESPACE)) {
                        stylesheetParser.pushNSContext(childElement);
                        if (elementName.localPartEquals("when")) {
                            if (otherwiseTemplate == null) {
                                whenList.add(WhenParser.parse(stylesheetParser, childElement));
                            } else {
                                stylesheetParser.reportError(childElement, "spe4");
                            }
                        } else if (elementName.localPartEquals("otherwise")) {
                            if (otherwiseTemplate == null) {
                                otherwiseTemplate = (OtherwiseTemplate)OtherwiseParser.parse(stylesheetParser, childElement);
                            } else {
                                stylesheetParser.reportError(element, childElement, "spe4");
                            }
                        } else {
                            stylesheetParser.reportError(element, childElement, "spe4");
                        }
                        stylesheetParser.popNSContext();
                        continue block5;
                    }
                    stylesheetParser.reportError(element, "spe4");
                    continue block5;
                }
                case 7: 
                case 8: {
                    continue block5;
                }
                case 3: 
                case 4: {
                    if (XMLUtil.isXMLWhitespace(child.getNodeValue())) continue block5;
                    stylesheetParser.reportError(child, "spe4");
                    continue block5;
                }
                default: {
                    stylesheetParser.reportError(child, "spe4");
                }
            }
        }
        WhenTemplate[] whenTemplates = new WhenTemplate[whenList.size()];
        if (whenList.size() > 0) {
            whenList.toArray(whenTemplates);
        } else {
            stylesheetParser.reportError((Node)element, "spe14", "xsl:when");
        }
        return new ChooseTemplate(whenTemplates, otherwiseTemplate, element);
    }
}

