/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.parser;

import com.novell.xml.util.ExpandedQName;
import com.novell.xsl.parser.AttrDef;
import com.novell.xsl.parser.StylesheetParser;
import com.novell.xsl.parser.XSLTParserException;
import java.text.DecimalFormatSymbols;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DecimalFormatParser {
    private static AttrDef[] decimalFormatAttr = new AttrDef[]{new AttrDef("name", 0, null, 6), new AttrDef("decimal-separator", 0, new Character('.'), 12), new AttrDef("grouping-separator", 0, new Character(','), 12), new AttrDef("infinity", 0, "Infinity", 9), new AttrDef("minus-sign", 0, new Character('-'), 12), new AttrDef("NaN", 0, "NaN", 9), new AttrDef("percent", 0, new Character('%'), 12), new AttrDef("per-mille", 0, new Character('\u2030'), 12), new AttrDef("zero-digit", 0, new Character('0'), 12), new AttrDef("digit", 0, new Character('#'), 12), new AttrDef("pattern-separator", 0, new Character(';'), 12)};
    private static final String FOUND_NAME = "dec-fmt-found";

    public static void parse(StylesheetParser stylesheetParser, Element element) throws XSLTParserException {
        DecimalFormatSymbols old;
        Object[] attr = AttrDef.parseAttributes(stylesheetParser, element, decimalFormatAttr);
        ExpandedQName name = null;
        if (attr[0] != null) {
            name = (ExpandedQName)attr[0];
        }
        char decimalSeparator = ((Character)attr[1]).charValue();
        char groupingSeparator = ((Character)attr[2]).charValue();
        String infinity = (String)attr[3];
        char minusSign = ((Character)attr[4]).charValue();
        String NaN = (String)attr[5];
        char percent = ((Character)attr[6]).charValue();
        char perMille = ((Character)attr[7]).charValue();
        char zeroDigit = ((Character)attr[8]).charValue();
        char digit = ((Character)attr[9]).charValue();
        char patternSeparator = ((Character)attr[10]).charValue();
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator(decimalSeparator);
        dfs.setGroupingSeparator(groupingSeparator);
        dfs.setInfinity(infinity);
        dfs.setMinusSign(minusSign);
        dfs.setNaN(NaN);
        dfs.setPercent(percent);
        dfs.setPerMill(perMille);
        dfs.setZeroDigit(zeroDigit);
        dfs.setDigit(digit);
        dfs.setPatternSeparator(patternSeparator);
        Boolean defaultFormatFound = (Boolean)stylesheetParser.getNamedObject(FOUND_NAME);
        if ((name != null || defaultFormatFound != null && defaultFormatFound.booleanValue()) && (old = stylesheetParser.getStylesheet().getDecimalFormat(name)) != null && !old.equals(dfs)) {
            if (name != null) {
                stylesheetParser.reportError((Node)element, "spe7", name.getQName());
            } else {
                stylesheetParser.reportError(element, "spe8");
            }
        }
        if (name == null) {
            stylesheetParser.setNamedObject(FOUND_NAME, Boolean.TRUE);
        }
        stylesheetParser.getStylesheet().setDecimalFormat(name, dfs);
    }
}

