/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.parser;

import com.novell.xml.dom.DOMUtil;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.Expression;
import com.novell.xsl.Stylesheet;
import com.novell.xsl.parser.AttrDef;
import com.novell.xsl.parser.StylesheetParser;
import com.novell.xsl.parser.XSLTParserException;
import com.novell.xsl.process.ForEachTemplate;
import com.novell.xsl.process.SortCriteria;
import com.novell.xsl.process.SortKey;
import com.novell.xsl.process.Template;
import com.novell.xsl.util.Util;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ForEachParser {
    private static AttrDef[] forEachAttr = new AttrDef[]{new AttrDef("select", 1, null, 8)};

    public static Template parse(StylesheetParser stylesheetParser, Element element) throws XSLTParserException {
        Object[] attr = AttrDef.parseAttributes(stylesheetParser, element, forEachAttr);
        if (attr[0] == null) {
            return null;
        }
        Expression select = (Expression)attr[0];
        Node[] nodeArg = new Node[]{element.getFirstChild()};
        SortCriteria sortCriteria = ForEachParser.parseSort(stylesheetParser, nodeArg);
        Template[] templates = stylesheetParser.parseTemplates(nodeArg[0], true);
        return new ForEachTemplate(select, templates, sortCriteria, element);
    }

    private static SortCriteria parseSort(StylesheetParser stylesheetParser, Node[] nodeArg) throws XSLTParserException {
        Node node;
        ArrayList<SortKey> list = new ArrayList<SortKey>();
        block5: for (node = nodeArg[0]; node != null; node = node.getNextSibling()) {
            switch (node.getNodeType()) {
                case 1: {
                    Element element = (Element)node;
                    ExpandedQName elementName = DOMUtil.getExpandedName(element);
                    if (!elementName.namespaceNameEquals(Stylesheet.NAMESPACE) || !elementName.localPartEquals("sort")) break block5;
                    stylesheetParser.pushNSContext(element);
                    list.add(stylesheetParser.parseSortElement(element));
                    stylesheetParser.popNSContext();
                    continue block5;
                }
                case 7: 
                case 8: {
                    continue block5;
                }
                case 3: 
                case 4: {
                    if (Util.stripWhitespaceNode(node)) continue block5;
                    break block5;
                }
            }
        }
        nodeArg[0] = node;
        if (list.size() == 0) {
            return null;
        }
        SortKey[] sortKeys = new SortKey[list.size()];
        list.toArray(sortKeys);
        return new SortCriteria(sortKeys, nodeArg[0].getParentNode());
    }
}

