/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.parser;

import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.StringValue;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Assert;
import com.novell.xsl.parser.AttrDef;
import com.novell.xsl.parser.StylesheetParser;
import com.novell.xsl.parser.XSLTParserException;
import com.novell.xsl.pattern.Pattern;
import com.novell.xsl.process.AnyNumberTemplate;
import com.novell.xsl.process.MultiNumberTemplate;
import com.novell.xsl.process.SingleNumberTemplate;
import com.novell.xsl.process.Template;
import org.w3c.dom.Element;

public class NumberParser {
    private static AttrDef[] numberAttr = new AttrDef[]{new AttrDef("level", 0, 0, new String[]{"single", "multiple", "any"}), new AttrDef("count", 0, null, 3), new AttrDef("from", 0, null, 3), new AttrDef("format", 0, new StringValue("1"), 0), new AttrDef("lang", 0, null, 0), new AttrDef("letter-value", 0, null, 0), new AttrDef("grouping-separator", 0, null, 0), new AttrDef("grouping-size", 0, null, 0), new AttrDef("value", 0, null, 11)};

    public static Template parse(StylesheetParser stylesheetParser, Element element) throws XSLTParserException {
        Object[] attr = AttrDef.parseAttributes(stylesheetParser, element, numberAttr);
        int level = (Integer)attr[0];
        Pattern countPattern = (Pattern)attr[1];
        Pattern fromPattern = (Pattern)attr[2];
        Expression formatExpr = (Expression)attr[3];
        Expression langExpr = (Expression)attr[4];
        Expression letterValueExpr = (Expression)attr[5];
        Expression digitGroupSepExpr = (Expression)attr[6];
        Expression digitsPerGroupExpr = (Expression)attr[7];
        Expression valueExpr = (Expression)attr[8];
        if (element.hasChildNodes()) {
            stylesheetParser.reportError(element, "spe4");
        }
        try {
            if (valueExpr != null) {
                level = 0;
            }
            switch (level) {
                default: {
                    Assert.assertCondition(false, "unexpected number level");
                }
                case 0: {
                    return new SingleNumberTemplate(countPattern, fromPattern, formatExpr, langExpr, letterValueExpr, digitGroupSepExpr, digitsPerGroupExpr, valueExpr, element);
                }
                case 1: {
                    return new MultiNumberTemplate(countPattern, fromPattern, formatExpr, langExpr, letterValueExpr, digitGroupSepExpr, digitsPerGroupExpr, element);
                }
                case 2: 
            }
            return new AnyNumberTemplate(countPattern, fromPattern, formatExpr, langExpr, letterValueExpr, digitGroupSepExpr, digitsPerGroupExpr, element);
        }
        catch (XSLException e) {
            stylesheetParser.reportError(element, e.getMessage());
            return null;
        }
    }
}

