/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.parser;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.XMLUtil;
import com.novell.xsl.parser.AttrDef;
import com.novell.xsl.parser.StylesheetParser;
import com.novell.xsl.parser.XSLTParserException;
import com.novell.xsl.result.SerializerOptions;
import java.util.Collection;
import org.w3c.dom.Element;

public class OutputParser {
    private static AttrDef[] outputAttr = new AttrDef[]{new AttrDef("method", 0, null, 6), new AttrDef("version", 0, null, 9), new AttrDef("indent", 0, -1, new String[]{"no", "yes"}), new AttrDef("encoding", 0, null, 9), new AttrDef("media-type", 0, null, 9), new AttrDef("doctype-system", 0, null, 9), new AttrDef("doctype-public", 0, null, 9), new AttrDef("omit-xml-declaration", 0, 0, new String[]{"no", "yes"}), new AttrDef("standalone", 0, 0, new String[]{"no", "yes"}), new AttrDef("cdata-section-elements", 0, null, 9)};

    public static void parse(StylesheetParser stylesheetParser, Element element) throws XSLTParserException {
        Object[] attr = AttrDef.parseAttributes(stylesheetParser, element, outputAttr);
        SerializerOptions options = new SerializerOptions();
        if (attr[0] != null) {
            options.setMethod((ExpandedQName)attr[0]);
        }
        if (attr[1] != null) {
            options.setVersion((String)attr[1]);
        }
        if (attr[2] != null) {
            options.setIndent((Integer)attr[2] != 0);
        }
        if (attr[3] != null) {
            if (!XMLUtil.isXMLEncName((String)attr[3])) {
                stylesheetParser.reportInvalidAttributeValue(element, "encoding", false, (String)attr[3]);
            } else {
                options.setEncoding((String)attr[3]);
            }
        }
        if (attr[4] != null) {
            options.setMediaType((String)attr[4]);
        }
        if (attr[5] != null) {
            options.setDoctypeSystem((String)attr[5]);
        }
        if (attr[6] != null) {
            options.setDoctypePublic((String)attr[6]);
        }
        if (attr[7] != null) {
            options.setDeclaration((Integer)attr[7] == 0);
        }
        if (attr[8] != null) {
            options.setStandalone((Integer)attr[8] != 0);
        }
        if (attr[9] != null) {
            Collection elements = stylesheetParser.parseQNames(element.getAttributeNode("cdata-section-elements"), (String)attr[9]);
            options.setCdataSectionElements(elements);
        }
        stylesheetParser.getStylesheet().setSerializerOptions(options, stylesheetParser.getImportPrecedence());
    }
}

