/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.parser;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.VariableBindings;
import com.novell.xsl.process.VariablePlaceholder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class ParserVariables
implements VariableBindings {
    private Map globalVariables = null;
    private Map templateVariables = null;
    private Stack stack = null;

    public Expression getVariable(ExpandedQName varName) {
        Expression variable;
        if (this.templateVariables != null && (variable = (Expression)this.templateVariables.get(varName)) != null) {
            return variable;
        }
        this.ensureGlobals();
        variable = (Expression)this.globalVariables.get(varName);
        if (variable != null) {
            return variable;
        }
        variable = new VariablePlaceholder(varName);
        this.globalVariables.put(varName, variable);
        return variable;
    }

    public void bindTopLevelVariable(ExpandedQName name, Expression variable) {
        this.ensureGlobals();
        Expression oldBinding = (Expression)this.globalVariables.get(name);
        if (oldBinding != null && oldBinding instanceof VariablePlaceholder) {
            ((VariablePlaceholder)oldBinding).setVariable(variable);
        }
        this.globalVariables.put(name, variable);
    }

    public void bindTemplateVariable(ExpandedQName name, Expression variable) {
        if (this.templateVariables == null) {
            this.templateVariables = new HashMap();
        } else if (!this.stack.empty() && this.templateVariables == (Map)this.stack.peek()) {
            this.templateVariables = new HashMap(this.templateVariables);
        }
        this.templateVariables.put(name, variable);
    }

    public boolean haveTemplateVariable(ExpandedQName name) {
        return this.templateVariables != null && this.templateVariables.containsKey(name);
    }

    public void resetTemplateVariables() {
        if (this.templateVariables != null) {
            this.templateVariables.clear();
        }
    }

    public void pushTemplateVariables() {
        if (this.stack == null) {
            this.stack = new Stack();
        }
        this.stack.push(this.templateVariables);
    }

    public void popTemplateVariables() {
        if (this.stack != null && !this.stack.empty()) {
            this.templateVariables = (Map)this.stack.pop();
        }
    }

    public Collection getTemplateVariables() {
        return this.templateVariables != null ? this.templateVariables.values() : null;
    }

    public Collection getTopLevelVariables() {
        return this.globalVariables != null ? this.globalVariables.values() : null;
    }

    private void ensureGlobals() {
        if (this.globalVariables == null) {
            this.globalVariables = new HashMap();
        }
    }
}

