/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.parser;

import com.novell.xml.dom.DOMUtil;
import com.novell.xml.dom.NodeImpl;
import com.novell.xml.parser.XMLParser;
import com.novell.xml.parser.XMLParserFactory;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.util.XMLUtil;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.Function;
import com.novell.xml.xpath.FunctionLibrary;
import com.novell.xml.xpath.NamespaceContext;
import com.novell.xml.xpath.Parser;
import com.novell.xml.xpath.WildcardName;
import com.novell.xml.xpath.XPathException;
import com.novell.xml.xpath.XPathParserException;
import com.novell.xml.xpath.XPathUtil;
import com.novell.xsl.Stylesheet;
import com.novell.xsl.XSLException;
import com.novell.xsl.extensions.AssignVariableTemplate;
import com.novell.xsl.extensions.BadExpression;
import com.novell.xsl.extensions.BadFunction;
import com.novell.xsl.extensions.BadTemplate;
import com.novell.xsl.extensions.ECMAScriptFunction;
import com.novell.xsl.extensions.ExtensibleFunctionLibrary;
import com.novell.xsl.extensions.TraceMessageTemplate;
import com.novell.xsl.parser.AVT;
import com.novell.xsl.parser.ApplyImportsParser;
import com.novell.xsl.parser.ApplyTemplatesParser;
import com.novell.xsl.parser.AttrDef;
import com.novell.xsl.parser.AttributeParser;
import com.novell.xsl.parser.AttributeSetParser;
import com.novell.xsl.parser.CallTemplateParser;
import com.novell.xsl.parser.ChooseParser;
import com.novell.xsl.parser.CommentParser;
import com.novell.xsl.parser.CopyOfParser;
import com.novell.xsl.parser.CopyParser;
import com.novell.xsl.parser.DecimalFormatParser;
import com.novell.xsl.parser.ElementParser;
import com.novell.xsl.parser.ExpressionParser;
import com.novell.xsl.parser.ForEachParser;
import com.novell.xsl.parser.IfParser;
import com.novell.xsl.parser.KeyParser;
import com.novell.xsl.parser.MessageParser;
import com.novell.xsl.parser.NamespaceAliasParser;
import com.novell.xsl.parser.NumberParser;
import com.novell.xsl.parser.OutputParser;
import com.novell.xsl.parser.ParserVariables;
import com.novell.xsl.parser.PreserveSpaceParser;
import com.novell.xsl.parser.ProcessingInstructionParser;
import com.novell.xsl.parser.StripSpaceParser;
import com.novell.xsl.parser.TemplateParser;
import com.novell.xsl.parser.TemplateVariableParser;
import com.novell.xsl.parser.TextParser;
import com.novell.xsl.parser.TopLevelParamParser;
import com.novell.xsl.parser.TopLevelVariableParser;
import com.novell.xsl.parser.ValueOfParser;
import com.novell.xsl.parser.XSLTParserException;
import com.novell.xsl.parser.XsltFunctionLibrary;
import com.novell.xsl.pattern.Pattern;
import com.novell.xsl.process.BuiltInTemplateRule;
import com.novell.xsl.process.ElementMatch;
import com.novell.xsl.process.FallbackTemplate;
import com.novell.xsl.process.FallbackTemplatesTemplate;
import com.novell.xsl.process.IdentityExpr;
import com.novell.xsl.process.LiteralElementTemplate;
import com.novell.xsl.process.Mode;
import com.novell.xsl.process.ProcessException;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.RuleCollection;
import com.novell.xsl.process.SortKey;
import com.novell.xsl.process.Template;
import com.novell.xsl.process.TemplateRule;
import com.novell.xsl.process.TextTemplate;
import com.novell.xsl.process.ValueOfTemplate;
import com.novell.xsl.process.VariablePlaceholder;
import com.novell.xsl.util.Util;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class StylesheetParser
implements NamespaceContext,
FunctionLibrary {
    private static AttrDef[] fallbackAttr = new AttrDef[0];
    private static AttrDef[] importAttr = new AttrDef[]{new AttrDef("href", 1, null, 9)};
    private static AttrDef[] sortAttr = new AttrDef[]{new AttrDef("select", 0, null, 11), new AttrDef("order", 0, null, 0), new AttrDef("lang", 0, null, 0), new AttrDef("data-type", 0, null, 0), new AttrDef("case-order", 0, null, 0)};
    private static AttrDef[] stylesheetAttr = new AttrDef[]{new AttrDef("version", 1, null, 9), new AttrDef("id", 0, null, 5), new AttrDef("extension-element-prefixes", 0, null, 9), new AttrDef("exclude-result-prefixes", 0, null, 9)};
    private Stylesheet stylesheet;
    private FunctionLibrary library;
    private int importance;
    private int nextImportPrecedence;
    private static final int IMPORT_GAP = 64;
    private int elementNumber;
    private Set extElementNamespaces = new HashSet();
    private Set excludedResultNamespaces = new HashSet();
    private Stack namespacesStack = new Stack();
    private Stack baseURIStack = new Stack();
    private com.novell.xsl.pattern.Parser patternParser;
    private ExpressionParser xpathParser;
    private ParserVariables variables = new ParserVariables();
    private Stack nsContextStack = new Stack();
    private Stack includeStack = new Stack();
    private boolean forwardsCompatibleMode = false;
    private Map namedObjects = null;
    private static Class[] PARSER_ARGS = new Class[]{XPathUtil.doGetClass("com.novell.xsl.parser.StylesheetParser"), XPathUtil.doGetClass("org.w3c.dom.Element")};

    public StylesheetParser(Stylesheet stylesheet) {
        this(stylesheet, new XsltFunctionLibrary());
    }

    public StylesheetParser(Stylesheet stylesheet, FunctionLibrary library) {
        this(stylesheet, library, false);
    }

    public StylesheetParser(Stylesheet stylesheet, FunctionLibrary library, boolean brokenMode) {
        this.stylesheet = stylesheet;
        this.library = library;
        this.patternParser = new com.novell.xsl.pattern.Parser(this, this.variables, this, this);
        this.xpathParser = new ExpressionParser(this, this.variables, this, this);
        this.patternParser.setBrokenMode(brokenMode);
        this.xpathParser.setBrokenMode(brokenMode);
    }

    public void setBuiltInDefinitions(Node namespaceContext) throws XSLTParserException {
        try {
            RuleCollection rules = this.stylesheet.getTemplateRules();
            TemplateRule rule = new BuiltInTemplateRule(this.patternParser.parsePattern("*", true), -1, null, this.elementNumber++, namespaceContext);
            rules.setBuiltIn(rule, 1);
            rule = (TemplateRule)rule.cloneForUnion(this.patternParser.parsePattern("/", true));
            rules.setBuiltIn(rule, 9);
            ValueOfTemplate valueOf = new ValueOfTemplate(new IdentityExpr(), false, namespaceContext);
            rule = new TemplateRule(this.patternParser.parsePattern("text()", true), null, new Template[]{valueOf}, null, Mode.ANY_MODE, -1, null, this.elementNumber++, namespaceContext);
            rules.setBuiltIn(rule, 3);
            rules.setBuiltIn(rule, 4);
            TemplateRule templateRule = (TemplateRule)rule.cloneForUnion(this.patternParser.parsePattern("@*", true));
        }
        catch (XPathParserException e) {
            this.reportError(e.getMessage());
        }
    }

    public void parse(Document xsltDocument2, URL baseURI) throws XSLTParserException {
        this.importance = Integer.MAX_VALUE;
        this.nextImportPrecedence = this.importance / 2;
        this.includeStylesheet(xsltDocument2, baseURI);
        this.checkVariables();
    }

    public boolean isForwardsCompatibleMode() {
        return this.forwardsCompatibleMode;
    }

    public Stylesheet getStylesheet() {
        return this.stylesheet;
    }

    public Parser getXPathParser() {
        return this.xpathParser;
    }

    public com.novell.xsl.pattern.Parser getPatternParser() {
        return this.patternParser;
    }

    public int getImportPrecedence() {
        return this.importance;
    }

    public int getElementNumber() {
        return this.elementNumber++;
    }

    public ParserVariables getVariables() {
        return this.variables;
    }

    public void setNamedObject(String name, Object object) {
        if (this.namedObjects == null) {
            this.namedObjects = new HashMap();
        }
        this.namedObjects.put(name, object);
    }

    public Object getNamedObject(String name) {
        return this.namedObjects == null ? null : this.namedObjects.get(name);
    }

    public Object removeNamedObject(String name) {
        return this.namedObjects == null ? null : this.namedObjects.remove(name);
    }

    protected void checkVariables() throws XSLTParserException {
        Collection topLevelVariables = this.variables.getTopLevelVariables();
        if (topLevelVariables != null) {
            Iterator it = topLevelVariables.iterator();
            while (it.hasNext()) {
                Expression variable = (Expression)it.next();
                if (!(variable instanceof VariablePlaceholder)) continue;
                this.reportError(null, "spe1", ((VariablePlaceholder)variable).getName().getQName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void includeStylesheet(Document xslDocument, URL baseURI) throws XSLTParserException {
        this.baseURIStack.push(baseURI);
        try {
            Element docElement = xslDocument.getDocumentElement();
            if (docElement == null) {
                this.reportError(xslDocument, "spe2");
            } else {
                ExpandedQName elementName = DOMUtil.getExpandedName(docElement);
                if (!elementName.namespaceNameEquals(Stylesheet.NAMESPACE) || !elementName.localPartEquals("stylesheet") && !elementName.localPartEquals("transform")) {
                    this.pushNSContext(docElement);
                    this.simplifiedStylesheet(docElement, this.stylesheet.getTemplateRules());
                    this.popNSContext();
                    return;
                }
                this.pushNSContext(docElement);
                this.parseStylesheet(docElement);
                this.popNSContext();
            }
        }
        finally {
            this.baseURIStack.pop();
        }
    }

    public Function getFunction(ExpandedQName name) throws XPathParserException {
        try {
            return this.library.getFunction(name);
        }
        catch (XPathParserException e) {
            if (this.forwardsCompatibleMode && name.getNamespaceName().isEmpty()) {
                return new BadFunction(e.getMessage());
            }
            throw e;
        }
    }

    public boolean isFunctionAvailable(ExpressionContext context, ExpandedQName name) {
        return this.library.isFunctionAvailable(context, name);
    }

    public void addFunction(Function function) {
        this.library.addFunction(function);
    }

    public NamespaceName getNamespaceName(String prefix) {
        if (prefix == null || prefix.length() <= 0 || this.nsContextStack.empty()) {
            return NamespaceName.NULL_NAMESPACE;
        }
        String uri = DOMUtil.getURIforNSPrefix(prefix, (Node)this.nsContextStack.peek());
        if (uri == null) {
            return NamespaceName.NULL_NAMESPACE;
        }
        return new NamespaceName(uri);
    }

    private Node getNamespaceContext() {
        return this.nsContextStack.empty() ? null : (Node)this.nsContextStack.peek();
    }

    public ExpandedQName getExpandedName(String qName) {
        int index = qName.indexOf(58);
        if (index == -1) {
            return new ExpandedQName("", qName);
        }
        String local_part = qName.substring(index + 1, qName.length());
        String prefix = qName.substring(0, index);
        return new ExpandedQName(this.getNamespaceName(prefix), local_part, prefix);
    }

    public void pushNSContext(Node newContext) {
        this.nsContextStack.push(newContext);
    }

    public Node popNSContext() {
        if (this.nsContextStack.empty()) {
            return null;
        }
        return (Node)this.nsContextStack.pop();
    }

    private void pushIncludeState() {
        this.includeStack.push(this.forwardsCompatibleMode ? Boolean.TRUE : Boolean.FALSE);
        this.includeStack.push(this.nsContextStack);
        this.nsContextStack = new Stack();
        this.includeStack.push(this.extElementNamespaces);
        this.includeStack.push(this.excludedResultNamespaces);
        this.extElementNamespaces = new HashSet();
    }

    private void popIncludeState() {
        this.excludedResultNamespaces = (Set)this.includeStack.pop();
        this.extElementNamespaces = (Set)this.includeStack.pop();
        this.nsContextStack = (Stack)this.includeStack.pop();
        this.forwardsCompatibleMode = (Boolean)this.includeStack.pop();
    }

    protected void parseStylesheet(Element element) throws XSLTParserException {
        NamespaceName[] namespaces;
        Object[] attr;
        Attr attribute;
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while ((attribute = (Attr)attrs.item(i++)) != null) {
            ExpandedQName name = DOMUtil.getExpandedName(attribute);
            if (!name.getNamespaceName().isEmpty() || !name.localPartEquals("version")) continue;
            this.forwardsCompatibleMode = !attribute.getNodeValue().equals("1.0");
            break;
        }
        if ((attr = AttrDef.parseAttributes(this, element, stylesheetAttr))[0] == null) {
            return;
        }
        if (attr[1] != null) {
            this.stylesheet.setID((String)attr[1]);
        }
        if (attr[2] != null) {
            namespaces = this.parseElementPrefixes(element, (String)attr[2]);
            for (i = 0; i < namespaces.length; ++i) {
                this.extElementNamespaces.add(namespaces[i]);
            }
        }
        if (attr[3] != null) {
            namespaces = this.parseElementPrefixes(element, (String)attr[3]);
            for (i = 0; i < namespaces.length; ++i) {
                this.excludedResultNamespaces.add(namespaces[i]);
            }
        }
        boolean importAllowed = true;
        block8: for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getNodeType()) {
                case 1: {
                    Element childElement = (Element)child;
                    ExpandedQName elementName = DOMUtil.getExpandedName(childElement);
                    if (elementName.namespaceNameEquals(Stylesheet.NAMESPACE)) {
                        if (elementName.localPartEquals("import")) {
                            if (importAllowed) {
                                this.parseImport(childElement);
                                continue block8;
                            }
                            this.reportError(element, childElement, "spe3");
                            continue block8;
                        }
                        importAllowed = false;
                        this.pushNSContext(childElement);
                        if (elementName.localPartEquals("template")) {
                            TemplateParser.parse(this, childElement);
                        } else if (elementName.localPartEquals("variable")) {
                            TopLevelVariableParser.parse(this, childElement);
                        } else if (elementName.localPartEquals("param")) {
                            TopLevelParamParser.parse(this, childElement);
                        } else if (elementName.localPartEquals("attribute-set")) {
                            AttributeSetParser.parse(this, childElement);
                        } else if (elementName.localPartEquals("include")) {
                            this.parseInclude(childElement);
                        } else if (elementName.localPartEquals("preserve-space")) {
                            PreserveSpaceParser.parse(this, childElement);
                        } else if (elementName.localPartEquals("strip-space")) {
                            StripSpaceParser.parse(this, childElement);
                        } else if (elementName.localPartEquals("key")) {
                            KeyParser.parse(this, childElement);
                        } else if (elementName.localPartEquals("decimal-format")) {
                            DecimalFormatParser.parse(this, childElement);
                        } else if (elementName.localPartEquals("output")) {
                            OutputParser.parse(this, childElement);
                        } else if (elementName.localPartEquals("namespace-alias")) {
                            NamespaceAliasParser.parse(this, childElement);
                        } else if (!this.forwardsCompatibleMode) {
                            this.reportError(element, childElement, "spe4");
                        }
                        this.popNSContext();
                        continue block8;
                    }
                    if (elementName.getNamespaceName().isEmpty()) {
                        if (this.forwardsCompatibleMode) continue block8;
                        this.reportError(element, childElement, "spe4");
                        continue block8;
                    }
                    if (!this.extElementNamespaces.contains(elementName.getNamespaceName())) continue block8;
                    this.parseTopLevelExtElement(childElement, elementName.getNamespaceName());
                    continue block8;
                }
                case 7: 
                case 8: {
                    continue block8;
                }
                case 3: 
                case 4: {
                    if (XMLUtil.isXMLWhitespace(child.getNodeValue())) continue block8;
                    this.reportError(child, "spe4");
                    continue block8;
                }
                default: {
                    this.reportError(child, "spe4");
                }
            }
        }
    }

    protected void simplifiedStylesheet(Element element, RuleCollection ruleCollection) throws XSLTParserException {
        try {
            NamedNodeMap attrs = element.getAttributes();
            boolean foundVersion = false;
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr attr = (Attr)attrs.item(i);
                ExpandedQName attrName = DOMUtil.getExpandedName(attr);
                if (!attrName.namespaceNameEquals(Stylesheet.NAMESPACE) || !attrName.localPartEquals("version")) continue;
                foundVersion = true;
                this.forwardsCompatibleMode = !attr.getNodeValue().equals("1.0");
            }
            if (!foundVersion) {
                this.reportError((Node)element, "spe5", "xsl:version");
            }
            Pattern matchPattern = this.patternParser.parsePattern("/", true);
            Template[] templates = this.parseTemplates(element, false);
            ruleCollection.add(new TemplateRule(matchPattern, null, templates, null, Mode.DEFAULT_MODE, this.importance, null, this.elementNumber++, element));
        }
        catch (XPathParserException e) {
            this.reportError(element, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseImport(Element element) throws XSLTParserException {
        URL[] uri = new URL[1];
        Document doc = this.parseIncludeOrImport(element, uri);
        if (doc != null) {
            int saveImportance = this.importance;
            int saveNext = this.nextImportPrecedence;
            this.pushIncludeState();
            this.importance = this.nextImportPrecedence;
            this.nextImportPrecedence -= 63;
            try {
                this.includeStylesheet(doc, uri[0]);
                Object var7_6 = null;
                this.popIncludeState();
                this.nextImportPrecedence = saveNext + 64;
                this.importance = saveImportance;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.popIncludeState();
                this.nextImportPrecedence = saveNext + 64;
                this.importance = saveImportance;
                throw throwable;
            }
        }
    }

    protected void parseInclude(Element element) throws XSLTParserException {
        URL[] uri = new URL[1];
        Document doc = this.parseIncludeOrImport(element, uri);
        if (doc != null) {
            this.pushIncludeState();
            this.includeStylesheet(doc, uri[0]);
            this.popIncludeState();
        }
    }

    protected Document parseIncludeOrImport(Element element, URL[] uri) throws XSLTParserException {
        Object[] attr = AttrDef.parseAttributes(this, element, importAttr);
        if (attr[0] == null) {
            return null;
        }
        String uriString = (String)attr[0];
        if (element.hasChildNodes()) {
            this.reportError(element, "spe4");
        }
        try {
            XMLParser xmlParser = XMLParserFactory.newParser();
            uri[0] = uriString.length() > 0 ? new URL((URL)this.baseURIStack.peek(), uriString) : (URL)this.baseURIStack.peek();
            if (this.baseURIStack.contains(uri[0])) {
                this.reportError((Node)element, "spe9", uriString);
                return null;
            }
            xmlParser.setContextURI(uri[0].toString());
            Document doc = xmlParser.parse(uri[0].openStream());
            if (xmlParser.anyErrors()) {
                this.reportError(element, xmlParser.getErrorMsgString());
            }
            if (this.getStylesheet().getXmlHook() != null) {
                doc = this.getStylesheet().getXmlHook().processDocument(doc);
            }
            return doc;
        }
        catch (MalformedURLException e) {
            this.reportError(element, e.toString());
            return null;
        }
        catch (IOException e) {
            this.reportError(element, e.toString());
            return null;
        }
        catch (Exception e) {
            this.reportError(element, e.toString());
            return null;
        }
    }

    public void parseStrippingList(Element contextNode, String elementList, boolean strip) throws XSLTParserException {
        StringTokenizer tokenizer = new StringTokenizer(elementList);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            try {
                WildcardName wcn = new WildcardName(token, (NamespaceContext)this);
                ElementMatch matcher = new ElementMatch(wcn, strip, this.importance, this.elementNumber++);
                this.stylesheet.getStripList().add(matcher);
            }
            catch (XPathException e) {
                this.reportError(contextNode, e.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Template[] parseTemplates(Node source, boolean sortWasAllowed) throws XSLTParserException {
        this.variables.pushTemplateVariables();
        try {
            ArrayList<TextTemplate> list = new ArrayList<TextTemplate>();
            while (source != null) {
                Template template = null;
                switch (source.getNodeType()) {
                    case 1: {
                        Element element = (Element)source;
                        ExpandedQName elementName = DOMUtil.getExpandedName(element);
                        if (elementName.namespaceNameEquals(Stylesheet.NAMESPACE)) {
                            this.pushNSContext(element);
                            if (elementName.localPartEquals("apply-templates")) {
                                template = ApplyTemplatesParser.parse(this, element);
                            } else if (elementName.localPartEquals("call-template")) {
                                template = CallTemplateParser.parse(this, element);
                            } else if (elementName.localPartEquals("apply-imports")) {
                                template = ApplyImportsParser.parse(this, element);
                            } else if (elementName.localPartEquals("variable")) {
                                template = TemplateVariableParser.parse(this, element);
                            } else if (elementName.localPartEquals("param")) {
                                this.reportError(element, "spe3");
                            } else if (elementName.localPartEquals("for-each")) {
                                template = ForEachParser.parse(this, element);
                            } else if (elementName.localPartEquals("text")) {
                                template = TextParser.parse(this, element);
                            } else if (elementName.localPartEquals("value-of")) {
                                template = ValueOfParser.parse(this, element);
                            } else if (elementName.localPartEquals("if")) {
                                template = IfParser.parse(this, element);
                            } else if (elementName.localPartEquals("choose")) {
                                template = ChooseParser.parse(this, element);
                            } else if (elementName.localPartEquals("element")) {
                                template = ElementParser.parse(this, element);
                            } else if (elementName.localPartEquals("attribute")) {
                                template = AttributeParser.parse(this, element);
                            } else if (elementName.localPartEquals("number")) {
                                template = NumberParser.parse(this, element);
                            } else if (elementName.localPartEquals("copy")) {
                                template = CopyParser.parse(this, element);
                            } else if (elementName.localPartEquals("copy-of")) {
                                template = CopyOfParser.parse(this, element);
                            } else if (elementName.localPartEquals("comment")) {
                                template = CommentParser.parse(this, element);
                            } else if (elementName.localPartEquals("processing-instruction")) {
                                template = ProcessingInstructionParser.parse(this, element);
                            } else if (elementName.localPartEquals("sort")) {
                                this.reportError(element, sortWasAllowed ? "spe3" : "spe4");
                            } else if (elementName.localPartEquals("message")) {
                                template = MessageParser.parse(this, element);
                            } else if (this.forwardsCompatibleMode) {
                                template = this.handleElementFallback(element);
                            } else {
                                this.reportError(element, "spe4");
                            }
                            this.popNSContext();
                            break;
                        }
                        if (this.extElementNamespaces.contains(elementName.getNamespaceName())) {
                            this.pushNSContext(element);
                            template = this.parseExtElement(element, elementName.getNamespaceName());
                            this.popNSContext();
                            break;
                        }
                        this.pushNSContext(element);
                        template = this.parseLiteralElement(element);
                        this.popNSContext();
                        break;
                    }
                    case 7: 
                    case 8: {
                        break;
                    }
                    case 3: 
                    case 4: {
                        if (Util.stripWhitespaceNode(source)) break;
                        template = new TextTemplate(source.getNodeValue(), false, source);
                        break;
                    }
                    default: {
                        this.reportError(source, "spe4");
                    }
                }
                if (template != null) {
                    list.add((TextTemplate)template);
                }
                source = source.getNextSibling();
            }
            Template[] templates = new Template[list.size()];
            list.toArray(templates);
            Template[] templateArray = templates;
            return templateArray;
        }
        finally {
            this.variables.popTemplateVariables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Template parseLiteralElement(Element element) throws XSLTParserException {
        LiteralElementTemplate literalElementTemplate;
        NamespaceName[] extNamespaces;
        block17: {
            int i;
            extNamespaces = null;
            NamespaceName[] exclNamespaces = null;
            Collection attributeSets = null;
            NamedNodeMap attributes = element.getAttributes();
            String[] names = new String[attributes.getLength()];
            Expression[] values = new Expression[attributes.getLength()];
            for (i = 0; i < attributes.getLength(); ++i) {
                String prefix;
                NamespaceName nsName;
                Node attribute = attributes.item(i);
                String name = attribute.getNodeName();
                if (name.startsWith("xmlns")) {
                    names[i] = null;
                    values[i] = null;
                    continue;
                }
                int index = name.indexOf(58);
                if (index > 0 && (nsName = this.getNamespaceName(prefix = name.substring(0, index))).equals(Stylesheet.NAMESPACE)) {
                    String localName = DOMUtil.getLocalName(attribute);
                    if (localName.equals("extension-element-prefixes")) {
                        extNamespaces = this.parseElementPrefixes(attribute, attribute.getNodeValue());
                        names[i] = null;
                        values[i] = null;
                        continue;
                    }
                    if (localName.equals("exclude-result-prefixes")) {
                        exclNamespaces = this.parseElementPrefixes(attribute, attribute.getNodeValue());
                        names[i] = null;
                        values[i] = null;
                        continue;
                    }
                    if (localName.equals("use-attribute-sets")) {
                        attributeSets = this.parseQNames(attribute, attribute.getNodeValue());
                        names[i] = null;
                        values[i] = null;
                        continue;
                    }
                    if (localName.equals("version")) {
                        this.forwardsCompatibleMode = !attribute.getNodeValue().equals("1.0");
                    }
                }
                names[i] = attribute.getNodeName();
                try {
                    values[i] = AVT.parse(attribute.getNodeValue(), this.xpathParser, this.stylesheet.getErrorHandler());
                    values[i].registerForReset(this.stylesheet);
                    continue;
                }
                catch (XPathParserException e) {
                    this.reportAttributeExpressionError(element, attribute.getNodeName(), e);
                    return null;
                }
            }
            if (extNamespaces != null) {
                this.namespacesStack.push(new HashSet(this.extElementNamespaces));
                for (i = 0; i < extNamespaces.length; ++i) {
                    this.extElementNamespaces.add(extNamespaces[i]);
                }
            }
            if (exclNamespaces != null) {
                this.namespacesStack.push(new HashSet(this.excludedResultNamespaces));
                for (i = 0; i < exclNamespaces.length; ++i) {
                    this.excludedResultNamespaces.add(exclNamespaces[i]);
                }
            }
            try {
                Template[] templates = this.parseTemplates(element.getFirstChild(), false);
                literalElementTemplate = new LiteralElementTemplate(element.getTagName(), names, values, this.extElementNamespaces, this.excludedResultNamespaces, attributeSets, templates, element);
                Object var16_17 = null;
                if (exclNamespaces == null) break block17;
            }
            catch (Throwable throwable) {
                block18: {
                    Object var16_18 = null;
                    if (exclNamespaces != null) {
                        this.excludedResultNamespaces = (Set)this.namespacesStack.pop();
                    }
                    if (extNamespaces == null) break block18;
                    this.extElementNamespaces = (Set)this.namespacesStack.pop();
                }
                throw throwable;
            }
            this.excludedResultNamespaces = (Set)this.namespacesStack.pop();
        }
        if (extNamespaces != null) {
            this.extElementNamespaces = (Set)this.namespacesStack.pop();
        }
        return literalElementTemplate;
    }

    protected Template parseExtElement(Element element, NamespaceName namespace) throws XSLTParserException {
        if (namespace.equals(Stylesheet.NXSL_NAMESPACE)) {
            String name = DOMUtil.getLocalName(element);
            if (name.equals("assign-variable")) {
                return AssignVariableTemplate.parse(this, element);
            }
            if (name.equals("trace-message")) {
                return TraceMessageTemplate.parse(this, element);
            }
        } else if (namespace.getString().startsWith("http://www.novell.com/nxsl/java/")) {
            Method parser;
            String parserName = namespace.getString().substring("http://www.novell.com/nxsl/java/".length(), namespace.getString().length());
            try {
                Class<?> parserClass = Class.forName(parserName);
                parser = parserClass.getMethod("parse", PARSER_ARGS);
                if (!Modifier.isStatic(parser.getModifiers())) {
                    throw new NoSuchMethodException("public static Template parse(StylesheetParser,Element)");
                }
            }
            catch (Throwable t) {
                this.reportWarning(element, t.toString());
                return this.handleElementFallback(element);
            }
            Object[] args = new Object[]{this, element};
            try {
                return (Template)parser.invoke(null, args);
            }
            catch (InvocationTargetException e) {
                throw (XSLTParserException)e.getTargetException();
            }
            catch (Throwable t) {
                this.reportError(element, t.toString());
                return null;
            }
        }
        return this.handleElementFallback(element);
    }

    protected void parseTopLevelExtElement(Element element, NamespaceName namespace) throws XSLTParserException {
        if (namespace.getString().startsWith("http://www.novell.com/nxsl/java/")) {
            Method parser;
            String parserName = namespace.getString().substring("http://www.novell.com/nxsl/java/".length(), namespace.getString().length());
            try {
                Class<?> parserClass = Class.forName(parserName);
                parser = parserClass.getMethod("parse", PARSER_ARGS);
                if (!Modifier.isStatic(parser.getModifiers())) {
                    throw new NoSuchMethodException("public static void parse(StylesheetParser,Element)");
                }
            }
            catch (Throwable t) {
                this.reportWarning(element, t.toString());
                return;
            }
            Object[] args = new Object[]{this, element};
            try {
                parser.invoke(null, args);
            }
            catch (InvocationTargetException e) {
                throw (XSLTParserException)e.getTargetException();
            }
            catch (Throwable t) {
                this.reportError(element, t.toString());
                return;
            }
        }
        if (namespace.getString().equals("http://www.novell.com/nxsl/ecmascript") && DOMUtil.getLocalName(element).equals("script")) {
            ClassLoader classLoader = null;
            if (this.library instanceof ExtensibleFunctionLibrary) {
                classLoader = ((ExtensibleFunctionLibrary)this.library).getClassLoader();
            }
            ECMAScriptFunction.parse(this, element, (URL)this.baseURIStack.peek(), classLoader);
        }
    }

    protected Template handleElementFallback(Element element) throws XSLTParserException {
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            ExpandedQName childName = DOMUtil.getExpandedName(child);
            if (!childName.namespaceNameEquals(Stylesheet.NAMESPACE) || !childName.localPartEquals("fallback")) continue;
            return this.parseFallbackTemplates((Element)child, element);
        }
        StringBuffer prologue = ProcessingEnv.buildMsgPrologue(null, element);
        prologue.append(ProcessException.constructMessage("pe17", new String[]{element.getTagName()}));
        return new BadTemplate(prologue.toString(), element);
    }

    protected FallbackTemplatesTemplate parseFallbackTemplates(Node node, Node context) throws XSLTParserException {
        ArrayList<FallbackTemplate> list = new ArrayList<FallbackTemplate>(4);
        while (node != null) {
            FallbackTemplate template;
            ExpandedQName elementName;
            if (node.getNodeType() == 1 && (elementName = DOMUtil.getExpandedName(node)).namespaceNameEquals(Stylesheet.NAMESPACE) && elementName.localPartEquals("fallback") && (template = this.parseFallbackTemplate((Element)node)) != null) {
                list.add(template);
            }
            node = node.getNextSibling();
        }
        Template[] templates = new Template[list.size()];
        list.toArray(templates);
        return new FallbackTemplatesTemplate(templates, context);
    }

    protected FallbackTemplate parseFallbackTemplate(Element element) throws XSLTParserException {
        AttrDef.parseAttributes(this, element, fallbackAttr);
        Template[] templates = this.parseTemplates(element.getFirstChild(), false);
        return new FallbackTemplate(templates, element);
    }

    public SortKey parseSortElement(Element element) throws XSLTParserException {
        Object[] attr = AttrDef.parseAttributes(this, element, sortAttr);
        return new SortKey((Expression)attr[0], (Expression)attr[1], (Expression)attr[2], (Expression)attr[3], (Expression)attr[4]);
    }

    public NamespaceName[] parseElementPrefixes(Node contextNode, String prefixList) throws XSLTParserException {
        ArrayList<NamespaceName> list = new ArrayList<NamespaceName>();
        StringTokenizer tokenizer = new StringTokenizer(prefixList);
        while (tokenizer.hasMoreTokens()) {
            NamespaceName nsName;
            String prefix = tokenizer.nextToken();
            if (prefix.equals("#default")) {
                prefix = "";
            }
            if ((nsName = this.getNamespaceName(prefix)) != null && !nsName.isEmpty()) {
                list.add(nsName);
                continue;
            }
            if (prefix.length() == 0) {
                prefix = "#default";
            }
            this.reportError(contextNode, "spe17", prefix);
        }
        NamespaceName[] ret = new NamespaceName[list.size()];
        list.toArray(ret);
        return ret;
    }

    public Collection parseQNames(Node contextNode, String string) throws XSLTParserException {
        TreeSet<ExpandedQName> list = new TreeSet<ExpandedQName>();
        StringTokenizer tokenizer = new StringTokenizer(string);
        while (tokenizer.hasMoreTokens()) {
            String qName = tokenizer.nextToken();
            if (!XMLUtil.isQName(qName)) {
                this.reportError(contextNode, "spe18", qName);
                continue;
            }
            ExpandedQName expandedName = new ExpandedQName(qName, this.getNamespaceContext());
            list.add(expandedName);
        }
        return list;
    }

    public void reportError(String msg) throws XSLTParserException {
        try {
            this.stylesheet.getErrorHandler().error(msg);
        }
        catch (XSLException e) {
            throw new XSLTParserException(e.getMessage());
        }
    }

    public void reportError(Element topLevelContext, Node contextNode, String key, Object[] parms) throws XSLTParserException {
        StringBuffer prologue = this.buildErrorPrologue(null, topLevelContext, contextNode);
        prologue = this.buildErrorPrologue(prologue, contextNode, null);
        prologue.append(XSLTParserException.constructMessage(key, parms));
        this.reportError(prologue.toString());
    }

    public void reportError(Element topLevelContext, Node contextNode, String key, String parm0) throws XSLTParserException {
        this.reportError(topLevelContext, contextNode, key, new String[]{parm0});
    }

    public void reportError(Element topLevelContext, Node contextNode, String key) throws XSLTParserException {
        this.reportError(topLevelContext, contextNode, key, (Object[])null);
    }

    public void reportError(Node contextNode, String key, Object[] parms) throws XSLTParserException {
        StringBuffer prologue = this.buildErrorPrologue(null, contextNode, contextNode);
        prologue.append(XSLTParserException.constructMessage(key, parms));
        this.reportError(prologue.toString());
    }

    public void reportError(Node contextNode, String key, String parm0) throws XSLTParserException {
        this.reportError(contextNode, key, new String[]{parm0});
    }

    public void reportError(Node contextNode, String key) throws XSLTParserException {
        this.reportError(contextNode, key, (Object[])null);
    }

    public void reportInvalidAttributeValue(Element contextNode, String attrName, boolean isRequired, String attrValue) throws XSLTParserException {
        if (this.forwardsCompatibleMode && !isRequired) {
            return;
        }
        this.reportError((Node)contextNode, "spe19", new String[]{attrName, attrValue});
    }

    public Expression reportAttributeExpressionError(Element contextNode, String attrName, XPathParserException e) throws XSLTParserException {
        StringBuffer prologue = this.buildErrorPrologue(null, contextNode, contextNode);
        prologue.append(XSLTParserException.constructMessage("spe20", new String[]{attrName, e.getLocalizedMessage()}));
        if (this.forwardsCompatibleMode) {
            return new BadExpression(prologue.toString());
        }
        this.reportError(prologue.toString());
        return null;
    }

    public StringBuffer buildErrorPrologue(StringBuffer prologue, Node contextNode, Node lineNumberContext) {
        if (prologue == null) {
            prologue = new StringBuffer();
        }
        if (contextNode == null) {
            return prologue;
        }
        if (lineNumberContext != null) {
            String uri = lineNumberContext instanceof NodeImpl ? ((NodeImpl)lineNumberContext).getBaseURI() : ((URL)this.baseURIStack.peek()).toString();
            prologue.append(uri);
            if (lineNumberContext instanceof NodeImpl && ((NodeImpl)lineNumberContext).getLineNumber() != -1) {
                prologue.append(" (");
                prologue.append(((NodeImpl)lineNumberContext).getLineNumber());
                prologue.append(')');
            }
            prologue.append(": ");
        }
        Node elementNode = contextNode;
        if (contextNode.getNodeType() != 1) {
            elementNode = contextNode.getParentNode();
        }
        if (elementNode != null && elementNode.getNodeType() == 1) {
            prologue.append('<');
            prologue.append(((Element)elementNode).getTagName());
            prologue.append(">: ");
        }
        if (contextNode != elementNode && contextNode.getNodeType() == 2) {
            prologue.append('\'');
            prologue.append(contextNode.getNodeName());
            prologue.append("': ");
        }
        return prologue;
    }

    public void reportWarning(Node contextNode, String msg) {
        StringBuffer prologue = this.buildErrorPrologue(null, contextNode, contextNode);
        prologue.append(msg);
        this.stylesheet.getErrorHandler().warning(prologue.toString());
    }
}

