/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.parser;

import com.novell.xml.dom.DOMUtil;
import com.novell.xml.util.ExpandedQName;
import com.novell.xsl.Stylesheet;
import com.novell.xsl.parser.AttrDef;
import com.novell.xsl.parser.ParamParser;
import com.novell.xsl.parser.ParserVariables;
import com.novell.xsl.parser.StylesheetParser;
import com.novell.xsl.parser.XSLTParserException;
import com.novell.xsl.pattern.OrPattern;
import com.novell.xsl.pattern.Pattern;
import com.novell.xsl.process.Mode;
import com.novell.xsl.process.Priority;
import com.novell.xsl.process.Rule;
import com.novell.xsl.process.RuleCollection;
import com.novell.xsl.process.Template;
import com.novell.xsl.process.TemplateRule;
import com.novell.xsl.process.VariableTemplate;
import com.novell.xsl.util.Util;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TemplateParser {
    private static AttrDef[] templateAttr = new AttrDef[]{new AttrDef("match", 0, null, 2), new AttrDef("mode", 0, null, 4), new AttrDef("name", 0, null, 6), new AttrDef("priority", 0, null, 7)};

    public static void parse(StylesheetParser stylesheetParser, Element element) throws XSLTParserException {
        ArrayList templateVariables;
        Mode mode;
        Rule rule;
        RuleCollection ruleCollection = stylesheetParser.getStylesheet().getTemplateRules();
        int importance = stylesheetParser.getImportPrecedence();
        Object[] attr = AttrDef.parseAttributes(stylesheetParser, element, templateAttr);
        Pattern matchPattern = null;
        ExpandedQName name = null;
        if (attr[0] == null && attr[2] == null) {
            stylesheetParser.reportError(element, "spe11");
            return;
        }
        if (attr[0] != null) {
            matchPattern = (Pattern)attr[0];
        }
        if (attr[2] != null && (rule = ruleCollection.getNamedRule(name = (ExpandedQName)attr[2])) != null && rule.getImportance() == importance) {
            stylesheetParser.reportError((Node)element, "spe7", name.getQName());
        }
        if (attr[1] != null) {
            if (matchPattern == null) {
                stylesheetParser.reportError(element, "spe12");
            }
            mode = (Mode)attr[1];
        } else {
            mode = Mode.DEFAULT_MODE;
        }
        Priority priority = (Priority)attr[3];
        Node childNode = element.getFirstChild();
        Template[] params = null;
        if (childNode != null) {
            Node[] nodeArg = new Node[]{childNode};
            params = TemplateParser.parseParams(stylesheetParser, nodeArg);
            childNode = nodeArg[0];
        }
        Template[] templates = stylesheetParser.parseTemplates(childNode, false);
        if (params != null && params.length > 0) {
            if (templates != null & templates.length > 0) {
                Template[] temp = new Template[params.length + templates.length];
                System.arraycopy(params, 0, temp, 0, params.length);
                System.arraycopy(templates, 0, temp, params.length, templates.length);
                templates = temp;
            } else {
                templates = params;
            }
        }
        if ((templateVariables = stylesheetParser.getVariables().getTemplateVariables()) != null) {
            templateVariables = new ArrayList(templateVariables);
        }
        if (matchPattern instanceof OrPattern) {
            Pattern[] patterns = ((OrPattern)matchPattern).getPatterns();
            TemplateRule rule2 = new TemplateRule(patterns[0], name, templates, templateVariables, mode, importance, priority, stylesheetParser.getElementNumber(), element);
            ruleCollection.add(rule2);
            for (int i = 1; i < patterns.length; ++i) {
                ruleCollection.add(((Rule)rule2).cloneForUnion(patterns[i]));
            }
        } else {
            ruleCollection.add(new TemplateRule(matchPattern, name, templates, templateVariables, mode, importance, priority, stylesheetParser.getElementNumber(), element));
        }
        stylesheetParser.getVariables().resetTemplateVariables();
    }

    private static Template[] parseParams(StylesheetParser stylesheetParser, Node[] nodeArg) throws XSLTParserException {
        Node node;
        ArrayList<Template> list = new ArrayList<Template>();
        ParserVariables variables = stylesheetParser.getVariables();
        block5: for (node = nodeArg[0]; node != null; node = node.getNextSibling()) {
            switch (node.getNodeType()) {
                case 1: {
                    Element element = (Element)node;
                    ExpandedQName elementName = DOMUtil.getExpandedName(element);
                    if (!elementName.namespaceNameEquals(Stylesheet.NAMESPACE) || !elementName.localPartEquals("param")) break block5;
                    stylesheetParser.pushNSContext(element);
                    Template template = ParamParser.parse(stylesheetParser, element);
                    stylesheetParser.popNSContext();
                    if (template == null) continue block5;
                    if (variables.haveTemplateVariable(((VariableTemplate)template).getName())) {
                        stylesheetParser.reportError((Node)element, "spe13", ((VariableTemplate)template).getName().getQName());
                        template = null;
                        continue block5;
                    }
                    variables.bindTemplateVariable(((VariableTemplate)template).getName(), (VariableTemplate)template);
                    list.add(template);
                    continue block5;
                }
                case 7: 
                case 8: {
                    continue block5;
                }
                case 3: 
                case 4: {
                    if (Util.stripWhitespaceNode(node)) continue block5;
                    break block5;
                }
            }
        }
        nodeArg[0] = node;
        if (list.size() == 0) {
            return null;
        }
        Template[] templates = new Template[list.size()];
        list.toArray(templates);
        return templates;
    }
}

