/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.pattern;

import com.novell.xml.xpath.AxisAttribute;
import com.novell.xml.xpath.ContextListMark;
import com.novell.xml.xpath.ContextNodeList;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.pattern.Pattern;
import org.w3c.dom.Node;

class AttributeList
implements ContextNodeList {
    private Pattern pattern;
    private ExpressionContext context;
    private AxisAttribute attributes;
    private Node sibling = null;
    private int position = 0;
    private int count = -1;

    public AttributeList(Node node, Pattern pattern, ExpressionContext context) {
        this.pattern = pattern;
        this.context = context;
        this.attributes = new AxisAttribute();
        this.attributes.setup(node.getParentNode(), context);
    }

    public Node first() throws XPathEvaluationException {
        this.sibling = this.attributes.first();
        while (this.sibling != null && !this.pattern.match(this.sibling, this.context)) {
            this.sibling = this.attributes.next();
        }
        return this.incPosition(this.sibling);
    }

    public Node next() throws XPathEvaluationException {
        this.sibling = this.attributes.next();
        while (this.sibling != null && !this.pattern.match(this.sibling, this.context)) {
            this.sibling = this.attributes.next();
        }
        return this.incPosition(this.sibling);
    }

    public int count() throws XPathEvaluationException {
        if (this.count == -1) {
            ContextListMark mark = this.getMark();
            if (this.position() < 1) {
                this.first();
            }
            while (this.next() == null) {
            }
            int saveCount = this.position();
            this.returnToMark(mark);
            this.count = saveCount;
        }
        return this.count;
    }

    public int position() {
        return this.position;
    }

    public int order() {
        return 1;
    }

    public ContextListMark getMark() {
        return new Mark(this);
    }

    public Node returnToMark(ContextListMark mark) {
        ((Mark)mark).restoreState(this);
        return this.sibling;
    }

    private Node incPosition(Node node) {
        if (node != null) {
            ++this.position;
        }
        return node;
    }

    private class Mark
    implements ContextListMark {
        private Node sibling;
        private int position;
        private int count;
        private ContextListMark attrMark;

        public Mark(AttributeList list) {
            this.sibling = list.sibling;
            this.position = list.position;
            this.count = list.count;
            this.attrMark = list.attributes.getMark();
        }

        public void restoreState(AttributeList list) {
            list.sibling = this.sibling;
            list.position = this.position;
            list.count = this.count;
            list.attributes.returnToMark(this.attrMark);
        }
    }
}

