/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.pattern;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.Axis;
import com.novell.xml.xpath.AxisAncestor;
import com.novell.xml.xpath.AxisParent;
import com.novell.xml.xpath.AxisSelf;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.FunctionCall;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.pattern.Pattern;
import com.novell.xsl.pattern.RelativePathPattern;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class IdKeyPattern
implements Pattern {
    private final FunctionCall functionCall;
    private final Axis axis;
    private final RelativePathPattern rhs;

    public IdKeyPattern(FunctionCall functionCall) {
        this.functionCall = functionCall;
        this.rhs = null;
        this.axis = new AxisSelf();
    }

    public IdKeyPattern(FunctionCall functionCall, int opr, RelativePathPattern rhs) {
        this.functionCall = functionCall;
        this.rhs = rhs;
        if (opr == 5) {
            this.axis = new AxisParent();
        } else if (opr == 6) {
            this.axis = new AxisAncestor();
        } else {
            throw new IllegalArgumentException("IdKeyPattern: invalid operator parameter");
        }
    }

    public boolean match(Node node, ExpressionContext context) throws XPathEvaluationException {
        if (this.rhs != null && (node = this.rhs.performMatch(node, context)) == null) {
            return false;
        }
        NodeSet result = this.functionCall.evaluate(node, context).getNodeSetValue();
        this.axis.setup(node, context);
        Node matchNode = this.axis.first();
        while (matchNode != null) {
            if (result.contains(matchNode)) {
                return true;
            }
            matchNode = this.axis.next();
        }
        return false;
    }

    public double getDefaultPriority() {
        return 0.5;
    }

    public int getTarget() {
        return 9;
    }

    public ExpandedQName getTargetName() {
        return null;
    }

    public void dump(PrintWriter writer, int indent) {
        this.functionCall.dump(writer, indent);
    }
}

