/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.pattern;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.NodeTest;
import com.novell.xml.xpath.NodeType;
import com.novell.xml.xpath.NodeTypePI;
import com.novell.xml.xpath.WildcardName;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathUtil;
import com.novell.xsl.pattern.Pattern;
import com.novell.xsl.pattern.PatternNodeType;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class NodeTestPattern
implements Pattern {
    private NodeTest nodeTest;
    private int nodeType;

    public NodeTestPattern(NodeTest nodeTest) {
        this.nodeTest = NodeTestPattern.useNodeTest(nodeTest);
        if (this.nodeTest instanceof WildcardName) {
            ((WildcardName)this.nodeTest).setPrincipalNodeType(1);
        }
        this.nodeType = 1;
    }

    public NodeTestPattern(NodeTest nodeTest, int nodeType) {
        this.nodeTest = NodeTestPattern.useNodeTest(nodeTest);
        if (this.nodeTest instanceof WildcardName) {
            ((WildcardName)this.nodeTest).setPrincipalNodeType(nodeType);
        }
        this.nodeType = nodeType;
    }

    public String toString() {
        if (this.nodeType == 2) {
            return "@" + this.nodeTest.toString();
        }
        return this.nodeTest.toString();
    }

    public boolean match(Node node, ExpressionContext context) throws XPathEvaluationException {
        return this.nodeTest.evaluate(node);
    }

    public double getDefaultPriority() {
        if (this.nodeTest instanceof WildcardName) {
            return Util.getWildcardNamePriority((WildcardName)this.nodeTest);
        }
        if (this.nodeTest instanceof NodeTypePI) {
            return 0.0;
        }
        return -0.5;
    }

    public int getTarget() {
        if (this.nodeTest instanceof NodeType) {
            int type = ((NodeType)this.nodeTest).getNodeType();
            switch (type) {
                case 1: {
                    return 5;
                }
                case 3: {
                    return 6;
                }
                case 4: {
                    return 7;
                }
            }
            return 9;
        }
        if (this.nodeTest instanceof WildcardName) {
            WildcardName wcn = (WildcardName)this.nodeTest;
            boolean prefixWild = wcn.getPrefix().equals("*");
            if (wcn.isFullWild() || prefixWild || wcn.isLocalWild()) {
                switch (this.nodeType) {
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 4;
                    }
                }
                throw new Error("Illegal type for NodeTestPattern.nodeType");
            }
            switch (this.nodeType) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 3;
                }
            }
            throw new Error("Illegal type for NodeTestPattern.nodeType");
        }
        return 9;
    }

    public ExpandedQName getTargetName() {
        if (this.nodeTest instanceof WildcardName) {
            return ((WildcardName)this.nodeTest).getName();
        }
        return null;
    }

    public void dump(PrintWriter writer, int indent) {
        XPathUtil.dump(this, writer, indent);
    }

    protected static NodeTest useNodeTest(NodeTest nodeTest) {
        if (nodeTest instanceof NodeType && ((NodeType)nodeTest).getNodeType() == 2) {
            return new PatternNodeType();
        }
        return nodeTest;
    }
}

