/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.pattern;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.ArgumentList;
import com.novell.xml.xpath.AxisNameToken;
import com.novell.xml.xpath.FunctionCall;
import com.novell.xml.xpath.FunctionLibrary;
import com.novell.xml.xpath.FunctionNameToken;
import com.novell.xml.xpath.NamespaceContext;
import com.novell.xml.xpath.StringValue;
import com.novell.xml.xpath.Token;
import com.novell.xml.xpath.VariableBindings;
import com.novell.xml.xpath.XPathParserException;
import com.novell.xsl.parser.ExpressionParser;
import com.novell.xsl.parser.StylesheetParser;
import com.novell.xsl.pattern.AbsolutePathPattern;
import com.novell.xsl.pattern.IdKeyPattern;
import com.novell.xsl.pattern.NodeTestPattern;
import com.novell.xsl.pattern.OrPattern;
import com.novell.xsl.pattern.Pattern;
import com.novell.xsl.pattern.PatternParserException;
import com.novell.xsl.pattern.RelativePathPattern;
import com.novell.xsl.pattern.StepPattern;

public class Parser
extends ExpressionParser {
    public Parser(StylesheetParser stylesheetParser, VariableBindings variables, FunctionLibrary library, NamespaceContext nsContext) {
        super(stylesheetParser, variables, library, nsContext);
    }

    public Pattern parsePattern(String source, boolean topLevel) throws XPathParserException {
        this.tokenize(source);
        Token[] tokens = this.getTokens();
        for (int i = 0; i < tokens.length; ++i) {
            FunctionNameToken token;
            if (topLevel && tokens[i].getType() == 17) {
                throw new PatternParserException(PatternParserException.NO_VARIABLE_REFS);
            }
            if (tokens[i].getType() != 13 || !(token = (FunctionNameToken)tokens[i]).getLocalPart().equals("current") || token.getPrefix().length() != 0) continue;
            throw new PatternParserException(PatternParserException.NO_CURRENT_FUNC);
        }
        Pattern pattern = this.parsePattern();
        if (this.peekToken().getType() != 0) {
            throw new PatternParserException("pe5");
        }
        return pattern;
    }

    protected Pattern parsePattern() throws XPathParserException {
        Token token;
        Pattern pattern = this.parseLocationPathPattern();
        while (this.getOperator(token = this.peekToken()) == 16) {
            this.nextToken();
            pattern = new OrPattern(pattern, this.parseLocationPathPattern());
        }
        return pattern;
    }

    protected Pattern parseLocationPathPattern() throws XPathParserException {
        Token token = this.peekToken();
        int opr = this.getOperator(token);
        if (opr == 5) {
            this.nextToken();
            token = this.peekToken();
            opr = this.getOperator(token);
            if (token.getType() != 0 && opr != 16) {
                return new AbsolutePathPattern(this.parseRelativePathPattern());
            }
            return new AbsolutePathPattern();
        }
        if (opr == 6) {
            this.nextToken();
            return this.parseRelativePathPattern();
        }
        if (token.getType() == 13) {
            return this.parseIdKeyPattern();
        }
        return this.parseRelativePathPattern();
    }

    protected Pattern parseIdKeyPattern() throws XPathParserException {
        ExpandedQName name;
        Token token = this.peekToken();
        this.nextToken();
        String prefix = ((FunctionNameToken)token).getPrefix();
        String fName = ((FunctionNameToken)token).getLocalPart();
        if (!prefix.equals("") || !fName.equals("id") && !fName.equals("key")) {
            throw new PatternParserException(PatternParserException.BAD_ID_KEY);
        }
        ArgumentList argList = this.parseArgumentList();
        if (fName.equals("id")) {
            if (argList.count() != 1 || !(argList.getArgument(0) instanceof StringValue)) {
                throw new PatternParserException(PatternParserException.BAD_ID_KEY);
            }
            name = new ExpandedQName("", "id", "");
        } else {
            if (argList.count() != 2 || !(argList.getArgument(0) instanceof StringValue) || !(argList.getArgument(1) instanceof StringValue)) {
                throw new PatternParserException(PatternParserException.BAD_ID_KEY);
            }
            name = new ExpandedQName("", "key", "");
        }
        FunctionCall fc = new FunctionCall(this.getLibrary().getFunction(name), argList);
        token = this.peekToken();
        int opr = this.getOperator(token);
        if (opr == 5 || opr == 6) {
            this.nextToken();
            return new IdKeyPattern(fc, opr, this.parseRelativePathPattern());
        }
        return new IdKeyPattern(fc);
    }

    protected RelativePathPattern parseRelativePathPattern() throws XPathParserException {
        RelativePathPattern pattern = new RelativePathPattern(this.parseStepPattern());
        while (true) {
            Token token;
            int opr;
            if ((opr = this.getOperator(token = this.peekToken())) == 5) {
                this.nextToken();
                pattern = new RelativePathPattern(pattern, 5, this.parseStepPattern());
                continue;
            }
            if (opr != 6) break;
            this.nextToken();
            pattern = new RelativePathPattern(pattern, 6, this.parseStepPattern());
        }
        return pattern;
    }

    protected StepPattern parseStepPattern() throws XPathParserException {
        StepPattern pattern = new StepPattern(this.parseAxisSpecifier());
        Token token = this.peekToken();
        while (token.getType() == 3) {
            this.nextToken();
            pattern = new StepPattern(pattern, this.parsePredicate());
            token = this.peekToken();
        }
        return pattern;
    }

    protected NodeTestPattern parseAxisSpecifier() throws XPathParserException {
        Token token = this.peekToken();
        int tokenType = token.getType();
        if (tokenType == 7) {
            this.nextToken();
            return new NodeTestPattern(this.parseNodeTest(), 2);
        }
        if (tokenType == 14) {
            this.nextToken();
            int axisName = ((AxisNameToken)token).getId();
            if (axisName != 4 && axisName != 3) {
                throw new PatternParserException(PatternParserException.BAD_AXIS);
            }
            token = this.peekToken();
            if (token.getType() != 9) {
                throw new PatternParserException("pe4", "::");
            }
            this.nextToken();
            if (axisName == 3) {
                return new NodeTestPattern(this.parseNodeTest(), 2);
            }
        }
        return new NodeTestPattern(this.parseNodeTest());
    }
}

