/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.pattern;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.Axis;
import com.novell.xml.xpath.AxisAncestor;
import com.novell.xml.xpath.AxisParent;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathUtil;
import com.novell.xsl.pattern.Pattern;
import com.novell.xsl.pattern.StepPattern;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class RelativePathPattern
implements Pattern {
    protected RelativePathPattern lhs;
    protected Axis axis = null;
    protected StepPattern rhs = null;

    public RelativePathPattern(StepPattern pattern) {
        this.rhs = pattern;
    }

    public RelativePathPattern(RelativePathPattern lhs, int opr, StepPattern rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
        if (opr == 5) {
            this.axis = new AxisParent();
        } else if (opr == 6) {
            this.axis = new AxisAncestor();
        } else {
            throw new IllegalArgumentException("RelativePathPattern: Invalid operator parameter");
        }
    }

    protected RelativePathPattern() {
        this.rhs = null;
        this.lhs = null;
        this.axis = null;
    }

    protected RelativePathPattern(RelativePathPattern copy) {
        this.rhs = copy.rhs;
        this.lhs = copy.lhs;
        this.axis = copy.axis;
    }

    public String toString() {
        if (this.lhs != null) {
            return this.lhs.toString() + "/" + this.rhs.toString();
        }
        return this.rhs.toString();
    }

    public boolean match(Node node, ExpressionContext context) throws XPathEvaluationException {
        return this.performMatch(node, context) != null;
    }

    public double getDefaultPriority() {
        if (this.lhs != null || this.axis != null || this.rhs == null) {
            return 0.5;
        }
        return this.rhs.getDefaultPriority();
    }

    public int getTarget() {
        return this.rhs != null ? this.rhs.getTarget() : 9;
    }

    public ExpandedQName getTargetName() {
        return this.rhs != null ? this.rhs.getTargetName() : null;
    }

    public void dump(PrintWriter writer, int indent) {
        XPathUtil.dump(this, writer, indent);
    }

    protected Node performMatch(Node node, ExpressionContext context) throws XPathEvaluationException {
        if (!this.rhs.match(node, context)) {
            return null;
        }
        if (this.axis == null || this.lhs == null) {
            return node;
        }
        this.axis.setup(node, context);
        node = this.axis.first();
        while (node != null) {
            if ((node = this.lhs.performMatch(node, context)) != null) {
                return node;
            }
            node = this.axis.next();
        }
        return null;
    }
}

