/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.pattern;

import com.novell.xml.xpath.ContextListMark;
import com.novell.xml.xpath.ContextNodeList;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.pattern.Pattern;
import org.w3c.dom.Node;

class SiblingList
implements ContextNodeList {
    private Node contextNode;
    private Pattern pattern;
    private ExpressionContext context;
    private Node sibling = null;
    private int position = 0;
    private int count = -1;

    public SiblingList(Node node, Pattern pattern, ExpressionContext context) {
        this.contextNode = node;
        this.pattern = pattern;
        this.context = context;
    }

    public Node first() throws XPathEvaluationException {
        Node parentNode = this.contextNode.getParentNode();
        Node node = this.sibling = parentNode != null ? parentNode.getFirstChild() : null;
        while (this.sibling != null && !this.pattern.match(this.sibling, this.context)) {
            this.sibling = this.sibling.getNextSibling();
        }
        return this.incPosition(this.sibling);
    }

    public Node next() throws XPathEvaluationException {
        if (this.sibling != null) {
            do {
                this.sibling = this.sibling.getNextSibling();
            } while (this.sibling != null && !this.pattern.match(this.sibling, this.context));
        }
        return this.incPosition(this.sibling);
    }

    public int count() throws XPathEvaluationException {
        if (this.count == -1) {
            ContextListMark mark = this.getMark();
            if (this.position() < 1) {
                this.first();
            }
            while (this.next() != null) {
            }
            int saveCount = this.position();
            this.returnToMark(mark);
            this.count = saveCount;
        }
        return this.count;
    }

    public int position() {
        return this.position;
    }

    public int order() {
        return 1;
    }

    public ContextListMark getMark() {
        return new Mark(this);
    }

    public Node returnToMark(ContextListMark mark) {
        ((Mark)mark).restoreState(this);
        return this.sibling;
    }

    private Node incPosition(Node node) {
        if (node != null) {
            ++this.position;
        }
        return node;
    }

    private class Mark
    implements ContextListMark {
        private Node sibling = null;
        private int position = 0;
        private int count = -1;

        public Mark(SiblingList list) {
            this.sibling = list.sibling;
            this.position = list.position;
            this.count = list.count;
        }

        public void restoreState(SiblingList list) {
            list.sibling = this.sibling;
            list.position = this.position;
            list.count = this.count;
        }
    }
}

