/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.pattern;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.ContextNodeList;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.Predicate;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathUtil;
import com.novell.xsl.pattern.AttributeList;
import com.novell.xsl.pattern.NodeTestPattern;
import com.novell.xsl.pattern.Pattern;
import com.novell.xsl.pattern.SiblingList;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class StepPattern
implements Pattern {
    private NodeTestPattern pattern;
    private Predicate[] predicates = null;

    public StepPattern(NodeTestPattern pattern) {
        this.pattern = pattern;
    }

    public StepPattern(StepPattern step, Predicate predicate) {
        this.pattern = step.pattern;
        if (step.predicates != null) {
            this.predicates = new Predicate[step.predicates.length + 1];
            for (int i = 0; i < step.predicates.length; ++i) {
                this.predicates[i] = step.predicates[i];
            }
            this.predicates[i] = predicate;
        } else {
            this.predicates = new Predicate[1];
            this.predicates[0] = predicate;
        }
    }

    public String toString() {
        if (this.predicates == null || this.predicates.length == 0) {
            return this.pattern.toString();
        }
        String result = this.pattern.toString();
        for (int i = 0; i < this.predicates.length; ++i) {
            result = result + this.predicates[i];
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean match(Node node, ExpressionContext context) throws XPathEvaluationException {
        if (this.pattern.match(node, context)) {
            if (this.predicates == null) {
                return true;
            }
            context.pushState();
            try {
                ContextNodeList list;
                switch (node.getNodeType()) {
                    case 2: {
                        list = new AttributeList(node, this.pattern, context);
                        break;
                    }
                    default: {
                        list = new SiblingList(node, this.pattern, context);
                    }
                }
                context.setContextNodeList(list);
                boolean bl = this.evaluatePredicate(0, node, context);
                return bl;
            }
            finally {
                context.popState();
            }
        }
        return false;
    }

    public double getDefaultPriority() {
        if (this.predicates == null || this.predicates.length == 0) {
            return this.pattern.getDefaultPriority();
        }
        return 0.5;
    }

    public int getTarget() {
        return this.pattern.getTarget();
    }

    public ExpandedQName getTargetName() {
        return this.pattern.getTargetName();
    }

    public void dump(PrintWriter writer, int indent) {
        XPathUtil.dump(this, writer, indent);
    }

    private boolean evaluatePredicate(int index, Node contextNode, ExpressionContext context) throws XPathEvaluationException {
        this.predicates[index].setup(context);
        Node node = this.predicates[index].first();
        if (contextNode.getNodeType() == 2) {
            while (node != null && !contextNode.equals(node)) {
                node = this.predicates[index].next();
            }
        } else {
            while (node != null && node != contextNode) {
                node = this.predicates[index].next();
            }
        }
        if (node == null) {
            return false;
        }
        if (index + 1 >= this.predicates.length) {
            return true;
        }
        ExpressionContext nextContext = new ExpressionContext(context);
        context.setContextNodeList(this.predicates[index]);
        return this.evaluatePredicate(index + 1, contextNode, nextContext);
    }
}

