/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathUtil;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Assert;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.pattern.Pattern;
import com.novell.xsl.process.NumberTemplate;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.result.IllegalNodeException;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class AnyNumberTemplate
extends NumberTemplate {
    public AnyNumberTemplate(Pattern countPattern, Pattern fromPattern, Expression formatExpr, Expression langExpr, Expression letterValueExpr, Expression digitGroupSepExpr, Expression digitsPerGroupExpr, Node nsContext) throws XSLException {
        super(countPattern, fromPattern, formatExpr, langExpr, letterValueExpr, digitGroupSepExpr, digitsPerGroupExpr, null, nsContext);
    }

    public void instantiate(ProcessingEnv env, Node currentNode, ResultHandler result) throws XSLException {
        Trace.traceTemplate("number");
        NumberTemplate.ParsedFormat parsedFormat = this.preparsedFormat;
        String digitGroupSep = null;
        int digitsPerGroup = 0;
        try {
            Node root;
            if (parsedFormat == null) {
                String format = env.getContext().evaluate(currentNode, this.formatExpr).getStringValue();
                String lang = null;
                if (this.langExpr != null) {
                    lang = env.getContext().evaluate(currentNode, this.langExpr).getStringValue();
                }
                String letterValue = null;
                if (this.letterValueExpr != null) {
                    letterValue = env.getContext().evaluate(currentNode, this.letterValueExpr).getStringValue();
                }
                parsedFormat = new NumberTemplate.ParsedFormat(format, lang, letterValue);
            }
            if (this.digitGroupSepExpr != null) {
                digitGroupSep = env.getContext().evaluate(currentNode, this.digitGroupSepExpr).getStringValue();
            }
            if (this.digitsPerGroupExpr != null) {
                digitsPerGroup = (int)env.getContext().evaluate(currentNode, this.digitsPerGroupExpr).getNumberValue();
            }
            if ((root = currentNode.getOwnerDocument()) == null) {
                root = currentNode;
            }
            Assert.assertCondition(root.getParentNode() == null, "document node is not the root");
            int[] count = new int[]{1};
            if (this.countPattern != null || currentNode.getNodeType() == 1) {
                this.count(root, currentNode, env.getContext(), count);
            }
            parsedFormat.formatStart(result);
            parsedFormat.formatNumber(count[0], 0, digitGroupSep, digitsPerGroup, result);
            parsedFormat.formatEnd(result);
        }
        catch (XPathEvaluationException e) {
            env.reportError(this.getNamespaceContext(), "pe2", e.getMessage());
        }
        catch (IllegalNodeException e) {
            env.reportError(this.getNamespaceContext(), "pe7");
        }
        catch (ResultException e) {
            env.reportError(this.getNamespaceContext(), "pe8", e.getMessage());
        }
    }

    public void dump(PrintWriter out, int indent) {
        Util.indent(out, indent);
        out.println("number level=any");
        super.dump(out, indent + 1);
    }

    private boolean count(Node node, Node currentNode, ExpressionContext context, int[] count) throws XSLException {
        try {
            if (node == currentNode) {
                return true;
            }
            if (this.fromPattern != null && this.fromPattern.match(node, context)) {
                count[0] = 1;
            } else if (this.countPattern != null) {
                if (this.countPattern.match(node, context)) {
                    count[0] = count[0] + 1;
                }
            } else if (node.getNodeType() == 1 && node.getNodeName().equals(currentNode.getNodeName())) {
                count[0] = count[0] + 1;
            }
            node = node.getFirstChild();
            while (node != null) {
                if (this.count(node, currentNode, context, count)) {
                    return true;
                }
                node = XPathUtil.getNextSibling(node);
            }
            return false;
        }
        catch (XPathEvaluationException e) {
            throw new XSLException(e.getMessage());
        }
    }
}

