/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.xpath.Axis;
import com.novell.xml.xpath.AxisChild;
import com.novell.xml.xpath.ContextNodeList;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.Mode;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.SortCriteria;
import com.novell.xsl.process.Template;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class ApplyTemplatesTemplate
implements Template {
    private final Expression select;
    private Mode mode;
    private final SortCriteria sortCriteria;
    private final Template[] params;
    private final Node nsContext;

    public ApplyTemplatesTemplate(Mode mode, Node nsContext) {
        this.select = null;
        this.mode = mode;
        this.sortCriteria = null;
        this.params = null;
        this.nsContext = nsContext;
    }

    public ApplyTemplatesTemplate(Expression select, Mode mode, SortCriteria sortCriteria, Template[] params, Node nsContext) {
        this.select = select;
        this.mode = mode;
        this.sortCriteria = sortCriteria;
        this.params = params;
        this.nsContext = nsContext;
    }

    public Expression getSelect() {
        return this.select;
    }

    public Mode getMode() {
        return this.mode;
    }

    public SortCriteria getSortCriteria() {
        return this.sortCriteria;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instantiate(ProcessingEnv env, Node currentNode, ResultHandler result) throws XSLException {
        Trace.traceTemplate("apply-templates", this.mode);
        if (this.select == null && !currentNode.hasChildNodes() || currentNode.getNodeType() == 2) {
            return;
        }
        env.getContext().pushState();
        try {
            env.pushParameters();
            env.pushVariables();
            try {
                ContextNodeList list;
                if (this.params != null) {
                    for (int i = 0; i < this.params.length; ++i) {
                        env.getContext().setNamespaceContext(this.params[i].getNamespaceContext());
                        this.params[i].instantiate(env, currentNode, result);
                    }
                }
                if (this.select != null) {
                    env.getContext().setNamespaceContext(this.getNamespaceContext());
                    list = env.getContext().evaluate(currentNode, this.select).getNodeSetValue();
                    Trace.traceSelect(this.select, (ExpressionValue)((Object)list));
                } else {
                    list = new AxisChild();
                    ((Axis)list).setup(currentNode, env.getContext());
                }
                if (this.sortCriteria != null) {
                    list = this.sortCriteria.sort(env, currentNode, list);
                }
                env.getContext().setContextNodeList(list);
                Node node = list.first();
                while (node != null) {
                    env.process(node, this.mode, result);
                    node = list.next();
                }
            }
            catch (XPathEvaluationException e) {
                env.reportError(this.getNamespaceContext(), "pe2", e.getMessage());
            }
            finally {
                env.popVariables();
                env.popParameters();
            }
        }
        finally {
            env.getContext().popState();
        }
    }

    public Node getNamespaceContext() {
        return this.nsContext;
    }

    public void dump(PrintWriter out, int indent) {
        Util.indent(out, indent);
        out.print("apply-templates");
        if (this.mode != Mode.DEFAULT_MODE) {
            out.print(" mode=" + this.mode.getName());
        }
        out.println();
        if (this.select != null) {
            Util.indent(out, indent + 1);
            out.println("select");
            this.select.dump(out, indent + 2);
        }
        if (this.sortCriteria != null) {
            this.sortCriteria.dump(out, indent + 1);
        }
    }
}

