/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.util.ExpandedQName;
import com.novell.xsl.XSLException;
import com.novell.xsl.process.AttributeSetCollection;
import com.novell.xsl.process.AttributeTemplate;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.Template;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;

public class AttributeSet
implements Template {
    private ExpandedQName name;
    private AttributeSetCollection attributeSets;
    private List attributes;
    private int importance;
    private Node nsContext;
    private int nesting = 0;

    public AttributeSet(ExpandedQName name, Collection attributeSetNames, Template[] attributes, int importance, Node nsContext) {
        this.name = name;
        this.attributeSets = attributeSetNames != null && attributeSetNames.size() != 0 ? new AttributeSetCollection(attributeSetNames) : null;
        this.importance = importance;
        this.nsContext = nsContext;
        this.attributes = new ArrayList();
        for (int i = 0; i < attributes.length; ++i) {
            this.attributes.add(attributes[i]);
        }
    }

    public ExpandedQName getName() {
        return this.name;
    }

    public void merge(AttributeSet otherSet) throws XSLException {
        Iterator thatIt = otherSet.attributes.iterator();
        while (thatIt.hasNext()) {
            this.attributes.add(thatIt.next());
        }
        Collections.sort(this.attributes, new AttributeTemplateComparator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instantiate(ProcessingEnv env, Node currentNode, ResultHandler result) throws XSLException {
        if (this.nesting > 0) {
            env.reportError(this.getNamespaceContext(), "pe3", this.name.getQName());
            return;
        }
        ++this.nesting;
        env.getContext().pushState();
        try {
            env.pushParameters();
            try {
                if (this.attributeSets != null) {
                    this.attributeSets.instantiate(env, currentNode, result);
                }
                Iterator attIt = this.attributes.iterator();
                while (attIt.hasNext()) {
                    ((AttributeTemplate)attIt.next()).instantiate(env, currentNode, result);
                }
            }
            finally {
                env.popParameters();
            }
        }
        finally {
            env.getContext().popState();
            --this.nesting;
        }
    }

    public Node getNamespaceContext() {
        return this.nsContext;
    }

    public void dump(PrintWriter out, int indent) {
        Util.indent(out, indent);
        out.println("attribute-set");
        Util.indent(out, indent + 1);
        out.println("name: " + this.name.getQName());
        Util.indent(out, indent + 1);
        out.println("attributes: ");
        Iterator attIt = this.attributes.iterator();
        while (attIt.hasNext()) {
            ((AttributeTemplate)attIt.next()).dump(out, indent + 2);
        }
    }

    static class AttributeTemplateComparator
    implements Comparator {
        AttributeTemplateComparator() {
        }

        public int compare(Object o1, Object o2) {
            AttributeTemplate a1 = (AttributeTemplate)o1;
            AttributeTemplate a2 = (AttributeTemplate)o2;
            if (a1.getImportance() != a2.getImportance()) {
                return a1.getImportance() - a2.getImportance();
            }
            return a1.getPosition() - a2.getPosition();
        }
    }
}

