/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.util.NamespaceName;
import com.novell.xml.util.XMLUtil;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.Template;
import com.novell.xsl.process.TemplateCollection;
import com.novell.xsl.result.AttributeAfterChildException;
import com.novell.xsl.result.IllegalNameException;
import com.novell.xsl.result.IllegalNodeException;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.result.TextResultHandler;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class AttributeTemplate
extends TemplateCollection {
    private final Expression name;
    private final Expression namespace;
    private final int importance;
    private final int position;

    public AttributeTemplate(Expression name, Expression namespace, Template[] templates, int importance, int position, Node nsContext) {
        super(templates, nsContext);
        this.name = name;
        this.namespace = namespace;
        this.importance = importance;
        this.position = position;
    }

    public Expression getNameExpression() {
        return this.name;
    }

    public Expression getNamespaceExpression() {
        return this.namespace;
    }

    public int getPosition() {
        return this.position;
    }

    public int getImportance() {
        return this.importance;
    }

    public void instantiate(ProcessingEnv env, Node currentNode, ResultHandler result) throws XSLException {
        Trace.traceTemplate("attribute");
        String attrName = null;
        try {
            int index;
            attrName = env.getContext().evaluate(currentNode, this.name).getStringValue();
            if (!XMLUtil.isQName(attrName)) {
                env.reportError(this.getNamespaceContext(), "pe5", attrName);
            }
            String prefix = (index = attrName.indexOf(58)) != -1 ? attrName.substring(0, index) : "";
            NamespaceName namespaceName = null;
            if (this.namespace == null) {
                if (prefix.length() > 0) {
                    namespaceName = env.getContext().getNamespaceName(prefix);
                }
            } else {
                namespaceName = new NamespaceName(env.getContext().evaluate(currentNode, this.namespace).getStringValue());
            }
            if (prefix.equals("xmlns")) {
                prefix = "_" + prefix;
                attrName = prefix + attrName.substring(index, attrName.length());
            }
            TextResultHandler textResult = new TextResultHandler();
            this.instantiateTemplates(env, currentNode, textResult);
            String attrValue = textResult.getText();
            if (namespaceName != null && !namespaceName.isEmpty()) {
                ProcessingEnv.resultNamespace(result, prefix, namespaceName);
            }
            result.attribute(attrName, attrValue);
        }
        catch (XPathEvaluationException e) {
            env.reportError(this.getNamespaceContext(), "pe2", e.getMessage());
        }
        catch (AttributeAfterChildException e) {
            env.reportError(this.getNamespaceContext(), "pe6", attrName);
        }
        catch (IllegalNameException e) {
            env.reportError(this.getNamespaceContext(), "pe5", attrName);
        }
        catch (IllegalNodeException e) {
            env.reportError(this.getNamespaceContext(), "pe7", attrName);
        }
        catch (ResultException e) {
            env.reportError(this.getNamespaceContext(), "pe8", e.getMessage());
        }
    }

    public void dump(PrintWriter out, int indent) {
        Util.indent(out, indent);
        out.println("attribute");
        Util.indent(out, indent + 1);
        out.println("name");
        this.name.dump(out, indent + 2);
        super.dump(out, indent);
    }
}

