/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.util.ExpandedQName;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.Mode;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.Rule;
import com.novell.xsl.process.Template;
import com.novell.xsl.process.TemplateCollection;
import com.novell.xsl.process.TemplateRule;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class CallTemplate
extends TemplateCollection {
    private final ExpandedQName templateName;

    public CallTemplate(ExpandedQName templateName, Template[] templates, Node nsContext) {
        super(templates, nsContext);
        this.templateName = templateName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instantiate(ProcessingEnv env, Node currentNode, ResultHandler result) throws XSLException {
        Trace.traceTemplate("call-template " + this.templateName.getQName());
        Rule template = env.getStylesheet().getTemplateRules().getNamedRule(this.templateName);
        if (template == null) {
            env.reportError(this.getNamespaceContext(), "pe9", this.templateName.getQName());
            return;
        }
        env.pushParameters();
        env.pushVariables();
        try {
            env.getContext().pushState();
            try {
                if (this.getTemplates().length > 0) {
                    Template[] templates = this.getTemplates();
                    for (int i = 0; i < templates.length; ++i) {
                        env.getContext().setNamespaceContext(templates[i].getNamespaceContext());
                        templates[i].instantiate(env, currentNode, result);
                    }
                }
                ((TemplateRule)template).instantiate(env, currentNode, Mode.ANY_MODE, result);
            }
            finally {
                env.getContext().popState();
            }
        }
        finally {
            env.popVariables();
            env.popParameters();
        }
    }

    public void dump(PrintWriter out, int indent) {
        Util.indent(out, indent);
        out.println("call-template name=" + this.templateName.getQName());
        super.dump(out, indent + 1);
    }
}

