/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.OtherwiseTemplate;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.Template;
import com.novell.xsl.process.TemplateCollection;
import com.novell.xsl.process.WhenTemplate;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class ChooseTemplate
extends TemplateCollection {
    private final OtherwiseTemplate otherwiseTemplate;

    public ChooseTemplate(WhenTemplate[] whenTemplates, OtherwiseTemplate otherwiseTemplate, Node nsContext) {
        super(whenTemplates, nsContext);
        this.otherwiseTemplate = otherwiseTemplate;
    }

    public OtherwiseTemplate getOtherwiseTemplate() {
        return this.otherwiseTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instantiate(ProcessingEnv env, Node currentNode, ResultHandler result) throws XSLException {
        Trace.traceTemplate("choose");
        env.getContext().pushState();
        try {
            Template[] whenTemplates = this.getTemplates();
            for (int i = 0; i < whenTemplates.length; ++i) {
                WhenTemplate when = (WhenTemplate)whenTemplates[i];
                if (when == null) continue;
                env.getContext().setNamespaceContext(when.getNamespaceContext());
                if (when == null || !when.isTrue(currentNode, env)) continue;
                whenTemplates[i].instantiate(env, currentNode, result);
                return;
            }
            if (this.otherwiseTemplate != null) {
                env.getContext().setNamespaceContext(this.otherwiseTemplate.getNamespaceContext());
                this.otherwiseTemplate.instantiate(env, currentNode, result);
            }
        }
        finally {
            env.getContext().popState();
        }
    }

    public void dump(PrintWriter out, int indent) {
        Util.indent(out, indent);
        out.println("choose");
        super.dump(out, indent + 1);
        if (this.otherwiseTemplate != null) {
            this.otherwiseTemplate.dump(out, indent + 1);
        }
    }
}

