/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.Template;
import com.novell.xsl.process.TemplateCollection;
import com.novell.xsl.result.IllegalNodeException;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.result.TextResultHandler;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class CommentTemplate
extends TemplateCollection {
    public CommentTemplate(Template[] templates, Node nsContext) {
        super(templates, nsContext);
    }

    public void instantiate(ProcessingEnv env, Node currentNode, ResultHandler result) throws XSLException {
        Trace.traceTemplate("comment");
        TextResultHandler textResult = new TextResultHandler();
        this.instantiateTemplates(env, currentNode, textResult);
        String value = textResult.getText();
        int i = value.lastIndexOf("--");
        if (i > 0) {
            env.reportError(this.getNamespaceContext(), "pe10");
            StringBuffer buf = new StringBuffer(value);
            do {
                buf.insert(i + 1, ' ');
            } while ((i = value.lastIndexOf("--", i - 1)) > 0);
            value = buf.toString();
        }
        if (value.endsWith("-")) {
            env.reportError(this.getNamespaceContext(), "pe10");
            value = value + " ";
        }
        try {
            result.comment(value);
        }
        catch (IllegalNodeException e) {
            env.reportError(this.getNamespaceContext(), "pe7");
        }
        catch (ResultException e) {
            env.reportError(this.getNamespaceContext(), "pe8", e.getMessage());
        }
    }

    public void dump(PrintWriter out, int indent) {
        Util.indent(out, indent);
        out.println("comment");
        super.dump(out, indent);
    }
}

